/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventCmsFinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsInitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1Cleanup;
import com.sap.jvm.profiling.memory.event.GcEventG1FinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1InitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventGenerational;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import java.util.ArrayList;

public class GcReportSystemOverload
implements GcReportBuilder {
    private static final double YELLOW_THRESHOLD_5 = 1.3;
    private static final double RED_THRESHOLD_5 = 1.5;
    private static final double YELLOW_THRESHOLD_15 = 0.9;
    private static final double RED_THRESHOLD_15 = 0.95;
    private double maxLoad5min = -1.0;
    private double maxLoad15min = -1.0;

    @Override
    public void handle(GcStatistic statistic) {
        for (GcEventBase event : statistic.getEvents()) {
            double[] load = null;
            if (event instanceof GcEventGenerational) {
                load = ((GcEventGenerational)event).getSystemLoadAverage();
            } else if (event instanceof GcEventCmsFinalMarking) {
                load = ((GcEventCmsFinalMarking)event).getSystemLoadAverage();
            } else if (event instanceof GcEventCmsInitialMarking) {
                load = ((GcEventCmsInitialMarking)event).getSystemLoadAverage();
            } else if (event instanceof GcEventG1Cleanup) {
                load = ((GcEventG1Cleanup)event).getSystemLoadAverage();
            } else if (event instanceof GcEventG1FinalMarking) {
                load = ((GcEventG1FinalMarking)event).getSystemLoadAverage();
            } else if (event instanceof GcEventG1InitialMarking) {
                load = ((GcEventG1InitialMarking)event).getSystemLoadAverage();
            }
            if (load == null) continue;
            this.maxLoad5min = Math.max(load[1], this.maxLoad5min);
            this.maxLoad15min = Math.max(load[2], this.maxLoad15min);
        }
    }

    @Override
    public String getReportTitle() {
        GcReportBuilder.Severity severity = this.getSeverity();
        if (severity == GcReportBuilder.Severity.RED || severity == GcReportBuilder.Severity.YELLOW) {
            return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"System Overload");
        }
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"System Load");
    }

    @Override
    public GcReportNode getReport() {
        ArrayList<GcReportNode> lines = new ArrayList<GcReportNode>();
        if (this.maxLoad15min > 0.9) {
            lines.add(new GcReportNode.Text(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The system was under heavy load for a long time.")));
        } else if (this.maxLoad5min > 1.3) {
            lines.add(new GcReportNode.Text(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The system was under heavy load for a short time.")));
        }
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The highest average load over a time of 15 minutes was {0}."), GcReportNode.getValueText(DataFormatter.getNumberText((double)this.maxLoad15min, (int)2), this.maxLoad15min > 0.95)));
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The highest average load over a time of 5 minutes was {0}."), GcReportNode.getValueText(DataFormatter.getNumberText((double)this.maxLoad15min, (int)2), this.maxLoad5min > 1.5)));
        lines.add(new GcReportNode.FormattedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The load average is normalized, a value of 1 means that all CPU cores are fully utilized."), false, true, -1, 0x808080));
        lines.add(new GcReportNode.Text(""));
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"See the Time Series ({0}) for more detailed load information."), new GcReportNode.Link("gc_report_system_load_timeseries", null, new GcReportNode.Text("System Load Average"))));
        return new GcReportNode.Paragraph(lines.toArray(new GcReportNode[lines.size()]));
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        if (this.maxLoad5min < 0.0) {
            return GcReportBuilder.Severity.NOTHING;
        }
        if (this.maxLoad15min > 0.95 || this.maxLoad5min > 1.5) {
            return GcReportBuilder.Severity.RED;
        }
        if (this.maxLoad15min > 0.9 || this.maxLoad5min > 1.5) {
            return GcReportBuilder.Severity.YELLOW;
        }
        return GcReportBuilder.Severity.GREEN;
    }
}

