/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.hprof;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpProperties;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpSnapshot;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import java.io.IOException;

public class HprofDumpSnapshotImpl
extends SnapshotImpl
implements HprofDumpSnapshot {
    private final ResourceName resourceName;
    private final HprofDumpProperties properties;

    public static HprofDumpSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        HprofDumpProperties properties = new HprofDumpProperties(reader);
        HprofDumpSnapshotImpl snapshot = new HprofDumpSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, properties, startTimestamp, endTimestamp, isVirtual);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public HprofDumpSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, HprofDumpProperties properties, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual) {
        super(SnapshotType.HPROF_DUMP_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, null);
        this.properties = properties;
        this.resourceName = resourceName;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        this.properties.write((ResourceWriter)writer);
    }

    @Override
    public HprofDumpProperties getProperties() {
        return this.properties;
    }
}

