/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.FilterByFileFilterResource;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.IOOperationsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.IOOperationsSerializer;
import com.sap.jvm.profiling.snapshot.io.CalledOpenFileStatistic;
import com.sap.jvm.profiling.snapshot.io.CallingOpenFileStatistic;
import com.sap.jvm.profiling.snapshot.io.Elements;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import java.io.IOException;

public final class CalledCallingOpenFileStatisticImpl
extends SelfAndTotalValueStatisticImpl<UTF8String, IOOperations>
implements CalledOpenFileStatistic,
CallingOpenFileStatistic {
    protected CalledCallingOpenFileStatisticImpl(ResourceName name) {
        super(name, new UTF8StringColumn(), new IOOperationsColumnImpl(), new IOOperationsColumnImpl(), new IOOperationsSerializer());
    }

    public CalledCallingOpenFileStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the file statistic ... (<%> %)"), reporter);
    }

    public static CalledCallingOpenFileStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        ResourceName filterName = null;
        ResourceNameElement createElement = name.getLastElement();
        filterName = createElement instanceof Elements.CreateCalledOpenFileStatistic ? ((Elements.CreateCalledOpenFileStatistic)createElement).getName() : ((Elements.CreateCallingOpenFileStatistic)createElement).getName();
        filterName.getResourceManager().get(filterName, reporter);
        ResourceName filteredSource = name.stripLastElement().addElement((ResourceNameElement)new FilterByFileFilterResource(filterName));
        IOValueIterator it = new IOValueIterator(filteredSource, reporter, I18n._s((String)"Creating the file statistic ... (<%> %)"));
        CalledCallingOpenFileStatisticImpl result = new CalledCallingOpenFileStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the file statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends SelfAndTotalStatisticCreator<UTF8String, IOOperations> {
        private Creator() {
        }

        @Override
        protected SelfAndTotalValueStatisticCollector<UTF8String, IOOperations> getCollector(ValueIterator<IOOperations> rawIt) throws IOException {
            IOValueIterator it = (IOValueIterator)rawIt;
            SelfAndTotalValueStatisticCollector<UTF8String, IOOperations> collector = new SelfAndTotalValueStatisticCollector<UTF8String, IOOperations>(IOOperations.EMPTY);
            while (it.next()) {
                UTF8String filename = it.getFilename();
                IOOperations value = it.getValue();
                collector.addTotal(it.getFilename(), value);
                collector.add(value);
                if (!it.hasSelfRoot()) continue;
                collector.addSelf(filename, value);
            }
            return collector;
        }
    }
}

