/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.Pruner;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CalledMethodTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.IOOperationsSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.MethodLocationSerializer;
import com.sap.jvm.profiling.snapshot.io.CalledMethodTree;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import java.io.IOException;

public final class CalledMethodTreeImpl
extends SelfAndTotalValueTreeImpl<MethodLocation, IOOperations>
implements CalledMethodTree {
    protected CalledMethodTreeImpl(ResourceName name) {
        super(name, new MethodLocationSerializer(), new IOOperationsSerializer());
    }

    public CalledMethodTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, reporter, I18n._s((String)"Reading the method tree ... (<%> %)"));
    }

    public static CalledMethodTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        IOValueIterator[] its = IOValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the method tree ... (<%> %)"), false);
        CalledMethodTreeImpl tree = new CalledMethodTreeImpl(name);
        new CalledMethodTreeCreator<IOOperations>().fillIn(tree, new TreePruner(), its);
        return tree;
    }

    @Override
    public void createChildren(SelfAndTotalValueTreeNode<MethodLocation, IOOperations> node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        IOValueIterator[] its = new IOValueIterator[]{new IOValueIterator(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"))};
        new CalledMethodTreeCreator<IOOperations>().setChildren(new TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void createSubNodes(SelfAndTotalValueTreeNode<MethodLocation, IOOperations> node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        IOValueIterator[] its = new IOValueIterator[]{new IOValueIterator(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"))};
        new CalledMethodTreeCreator<IOOperations>().setSubNodes(new TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the method tree ... (<%> %)"));
    }

    public static class TreePruner
    implements Pruner<IOOperations> {
        @Override
        public boolean shouldPrune(IOOperations value, IOOperations parentValue, IOOperations totalValue) {
            double fraction = 1.0E-4;
            if (fraction * (double)totalValue.getReadBytes() >= (double)value.getReadBytes() && fraction * (double)totalValue.getWrittenBytes() >= (double)value.getWrittenBytes()) {
                return true;
            }
            int scale = 7;
            long relativeReadBytes = value.getReadBytes() << scale;
            long relativeWrittenBytes = value.getWrittenBytes() << scale;
            return parentValue.getReadBytes() >= relativeReadBytes && parentValue.getWrittenBytes() >= relativeWrittenBytes;
        }
    }
}

