/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.series.AbstractValueTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.io.CalledTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import java.io.IOException;

public class CalledTimeSeriesCollectionImpl
extends AbstractValueTimeSeriesCollection<IOOperations>
implements CalledTimeSeriesCollection {
    private long openFiles = 0L;
    private IOValueIterator iterator = null;

    public CalledTimeSeriesCollectionImpl(ResourceName name) throws IOException {
        super(name);
    }

    public CalledTimeSeriesCollectionImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reader, reporter, I18n._s((String)"Reading the time series ... (<%> %)"));
    }

    public static CalledTimeSeriesCollectionImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        CalledTimeSeriesCollectionImpl result = new CalledTimeSeriesCollectionImpl(name);
        result.iterator = IOValueIterator.getEventIterator(name, reporter, I18n._s((String)"Creating the time series ... (<%> %)"));
        result.createTimeSeries(result.iterator);
        return result;
    }

    @Override
    protected void getValuesForValue(long[] values, long elapsed, IOOperations value) {
        this.openFiles = this.openFiles + value.getOpenCount() - value.getCloseCount();
        values[0] = (long)this.iterator.getNrOfSyntheticOpenEvents() + this.openFiles;
        values[1] = value.getReadBytes() * 1000L / elapsed;
        values[2] = value.getReadOperations() * 1000L / elapsed;
        values[3] = value.getReadTime() * 1000L / elapsed;
        values[4] = value.getWrittenBytes() * 1000L / elapsed;
        values[5] = value.getWriteOperations() * 1000L / elapsed;
        values[6] = value.getWriteTime() * 1000L / elapsed;
    }
}

