/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.io.IOOperationsAndDetailsIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.FileIdColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.IOOperationsAndDetailsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.IOOperationsAndDetailsSerializer;
import com.sap.jvm.profiling.snapshot.io.DetailedFileStatistic;
import com.sap.jvm.profiling.snapshot.io.IOOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.resource.FileId;
import java.io.IOException;

public final class DetailedFileStatisticImpl
extends ValueStatisticImpl<FileId, IOOperationsAndDetails>
implements DetailedFileStatistic {
    protected DetailedFileStatisticImpl(ResourceName name) {
        super(name, new FileIdColumn(), new IOOperationsAndDetailsColumnImpl(), new IOOperationsAndDetailsSerializer());
    }

    public DetailedFileStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the detailed file statistic ... (<%> %)"), reporter);
    }

    public static DetailedFileStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        IOOperationsAndDetailsIterator it = new IOOperationsAndDetailsIterator(name, reporter, I18n._s((String)"Creating the detailed file statistic ... (<%> %)"));
        DetailedFileStatisticImpl result = new DetailedFileStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the detailed file statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<FileId, IOOperationsAndDetails> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<FileId, IOOperationsAndDetails> getCollector(ValueIterator<IOOperationsAndDetails> rawIt) throws IOException {
            IOOperationsAndDetailsIterator it = (IOOperationsAndDetailsIterator)rawIt;
            ValueStatisticCollector<FileId, IOOperationsAndDetails> collector = new ValueStatisticCollector<FileId, IOOperationsAndDetails>(IOOperationsAndDetails.EMPTY);
            while (it.next()) {
                collector.add(it.getFileId(), it.getValue());
                collector.add(it.getValue());
            }
            return collector;
        }
    }
}

