/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.IOOperationsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.IOOperationsSerializer;
import com.sap.jvm.profiling.snapshot.io.FileStatistic;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import java.io.IOException;

public final class FileStatisticImpl
extends ValueStatisticImpl<UTF8String, IOOperations>
implements FileStatistic {
    protected FileStatisticImpl(ResourceName name) {
        super(name, new UTF8StringColumn(), new IOOperationsColumnImpl(), new IOOperationsSerializer());
    }

    public FileStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the file statistic ... (<%> %)"), reporter);
    }

    public static FileStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        IOValueIterator it = new IOValueIterator(name, reporter, I18n._s((String)"Creating the file statistic ... (<%> %)"));
        FileStatisticImpl result = new FileStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the file statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<UTF8String, IOOperations> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<UTF8String, IOOperations> getCollector(ValueIterator<IOOperations> rawIt) throws IOException {
            IOValueIterator it = (IOValueIterator)rawIt;
            ValueStatisticCollector<UTF8String, IOOperations> collector = new ValueStatisticCollector<UTF8String, IOOperations>(IOOperations.EMPTY);
            while (it.next()) {
                collector.add(it.getFilename(), it.getValue());
                collector.add(it.getValue());
            }
            return collector;
        }
    }
}

