/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIteratorBase;
import com.sap.jvm.profiling.snapshot.impl.io.StackStatisticImpl;
import com.sap.jvm.profiling.snapshot.io.Elements;
import com.sap.jvm.profiling.snapshot.io.IOOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.io.StackIterator;
import java.io.IOException;

public class IOOperationsAndDetailsIterator
extends IOValueIteratorBase<IOOperationsAndDetails> {
    public IOOperationsAndDetailsIterator(Snapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(snapshot, name, reporter, message);
    }

    public IOOperationsAndDetailsIterator(ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(name, reporter, message);
    }

    public IOOperationsAndDetailsIterator(StackIterator it, ResourceName name, ProgressReporter reporter) {
        super(it, name, reporter);
    }

    public static IOOperationsAndDetailsIterator getEventIterator(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        return IOOperationsAndDetailsIterator.getIterators(name, 1, reporter, message, true)[0];
    }

    public static IOOperationsAndDetailsIterator[] getIterators(ResourceName name, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        return IOOperationsAndDetailsIterator.getIterators(name, name.getSession().getNrOfThreads(), reporter, message, usesEvents);
    }

    public static IOOperationsAndDetailsIterator[] getIterators(ResourceName name, int nrOfIterators, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        ProfilingSession session = name.getSession();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(session).getSnapshot(name);
        if (usesEvents || IOOperationsAndDetailsIterator.needsEventIteration(name)) {
            return new IOOperationsAndDetailsIterator[]{new IOOperationsAndDetailsIterator(snapshot, name, reporter, message)};
        }
        ResourceName sName = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateStackStatistic());
        StackStatisticImpl statistic = (StackStatisticImpl)session.getResourceManager().get(sName, reporter);
        if (statistic == null) {
            throw new OperationCanceledException();
        }
        StackStatisticImpl.StackIteratorImpl[] baseIterators = statistic.getIterators(nrOfIterators);
        IOOperationsAndDetailsIterator[] result = new IOOperationsAndDetailsIterator[baseIterators.length];
        ProgressReporter[] dummyReporters = reporter.getChildren(nrOfIterators - 1);
        result[0] = new IOOperationsAndDetailsIterator(baseIterators[0], name, reporter);
        for (int i = 1; i < result.length; ++i) {
            result[i] = new IOOperationsAndDetailsIterator(baseIterators[i], name, dummyReporters[i - 1]);
        }
        reporter.setWork(message, result[0].it.getMaxProgress());
        return result;
    }

    @Override
    public IOOperationsAndDetails getEmptyValue() {
        return IOOperationsAndDetails.EMPTY;
    }

    @Override
    public IOOperationsAndDetails getValue() {
        return this.getOperationsAndDetails();
    }
}

