/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.io.command.IOTraceConfiguration;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIterator;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import com.sap.jvm.profiling.snapshot.io.IOSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class IOSnapshotImpl
extends SnapshotImpl
implements IOSnapshot {
    private ResourceName resourceName;
    private long nrOfReadBytes;
    private long nrOfWrittenBytes;
    private long readDuration;
    private long writeDuration;
    private final IOTraceConfiguration config;

    public static IOSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long nrOfReadBytes = reader.readInt64();
        long nrOfWrittenBytes = reader.readInt64();
        long readDuration = reader.readInt64();
        long writeDuration = reader.readInt64();
        IOTraceConfiguration config = IOSnapshotImpl.readIOTraceConfig(reader);
        IOSnapshotImpl snapshot = new IOSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, config, nrOfReadBytes, nrOfWrittenBytes, readDuration, writeDuration, startTimestamp, endTimestamp, isVirtual, null);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public IOSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, IOTraceConfiguration config, long nrOfReadBytes, long nrOfWrittenBytes, long readDuration, long writeDuration, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, IOSnapshot parent) {
        super(SnapshotType.IO_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.config = config;
        this.nrOfReadBytes = nrOfReadBytes;
        this.nrOfWrittenBytes = nrOfWrittenBytes;
        this.readDuration = readDuration;
        this.writeDuration = writeDuration;
        this.resourceName = resourceName;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        if (this.nrOfReadBytes >= 0L && this.nrOfWrittenBytes > 0L && this.readDuration >= 0L && this.writeDuration >= 0L) {
            return;
        }
        this.nrOfReadBytes = 0L;
        this.nrOfWrittenBytes = 0L;
        this.readDuration = 0L;
        this.writeDuration = 0L;
        IOValueIterator it = new IOValueIterator(this, this.asResourceName(), reporter, I18n._s((String)"Analyzing the I/O events ... (<%> %)"));
        try {
            while (it.next()) {
                IOOperations value = it.getValue();
                this.nrOfReadBytes += value.getReadBytes();
                this.readDuration += value.getReadTime();
                this.nrOfWrittenBytes += value.getWrittenBytes();
                this.writeDuration += value.getWriteTime();
            }
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Failed to analyze the I/O events");
        }
    }

    @Override
    public long getNrOfTransferredBytes() {
        return this.nrOfReadBytes + this.nrOfWrittenBytes;
    }

    @Override
    public long getNrOfWrittenBytes() {
        return this.nrOfWrittenBytes;
    }

    @Override
    public long getNrOfReadBytes() {
        return this.nrOfReadBytes;
    }

    @Override
    public long getDuration() {
        return this.readDuration + this.writeDuration;
    }

    @Override
    public long getReadDuration() {
        return this.readDuration;
    }

    @Override
    public long getWriteDuration() {
        return this.writeDuration;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfReadBytes);
        writer.writeInt64(this.nrOfWrittenBytes);
        writer.writeInt64(this.readDuration);
        writer.writeInt64(this.writeDuration);
        this.writeIOTraceConfig((ResourceWriter)writer);
    }

    @Override
    public IOTraceConfiguration getTraceConfiguration() {
        return this.config;
    }

    private void writeIOTraceConfig(ResourceWriter writer) throws IOException {
        writer.writeNewThreadFilter(this.config.getThreadFilter());
    }

    private static IOTraceConfiguration readIOTraceConfig(ResourceReader reader) throws IOException {
        ThreadFilter threadFilter = reader.readNewThreadFilter();
        IOTraceConfiguration retValue = new IOTraceConfiguration();
        retValue.setThreadFilter(threadFilter);
        return retValue;
    }
}

