/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.io.event.FileCloseEvent;
import com.sap.jvm.profiling.io.event.FileNotFoundEvent;
import com.sap.jvm.profiling.io.event.FileOpenEvent;
import com.sap.jvm.profiling.io.event.FileReadEvent;
import com.sap.jvm.profiling.io.event.FileWriteEvent;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.io.response.DisableIOTraceResponse;
import com.sap.jvm.profiling.io.response.EnableIOTraceResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.filter.FileFilter;
import com.sap.jvm.profiling.snapshot.impl.io.IOTraceNameExtractor;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.io.IODetails;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import com.sap.jvm.profiling.snapshot.io.IOOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.io.StackIterator;
import com.sap.jvm.profiling.snapshot.resource.FileId;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class IOValueIteratorBase<V extends Value<V>>
extends AbstractValueIterator<V>
implements IOEventHandler {
    private final ProfilingReader reader;
    private FileOpenEvent currentFileOpenEvent;
    private FileReadEvent currentFileReadEvent;
    private FileWriteEvent currentFileWriteEvent;
    private FileCloseEvent currentFileCloseEvent;
    private FileId currentFileId;
    private FileFilter fileFilter;
    private Map<Long, UTF8String> fd2Filename;
    private Map<Long, Long> id2Index;
    private long nextIndex;
    public final StackIterator it;
    private final ProgressReporter reporter;
    private FileOpenEvent[] initiallyOpenedFiles;
    private int initiallyOpenedFilesIndex = -1;
    private int syntheticOpenEventsCount = 0;

    public IOValueIteratorBase(Snapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(name, snapshot, reporter);
        this.fileFilter = IOTraceNameExtractor.getFileFilter(name);
        this.reader = this.getEventReader();
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.fd2Filename = new HashMap<Long, UTF8String>();
        this.id2Index = new HashMap<Long, Long>();
        this.nextIndex = 0L;
        this.reader.registerIOEventHandler((IOEventHandler)this);
        this.it = null;
    }

    protected IOValueIteratorBase(StackIterator it, ResourceName name, ProgressReporter reporter) {
        super(name, null);
        assert (!this.usesEvents());
        this.reporter = reporter;
        this.it = it;
        this.reader = null;
    }

    public IOValueIteratorBase(ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        this(SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name), name, reporter, message);
    }

    @Override
    public int getStackIndex() {
        if (this.it != null) {
            return this.it.getStackIndex();
        }
        if (this.currentFileReadEvent != null) {
            return this.currentFileReadEvent.getStackTraceIndex();
        }
        if (this.currentFileWriteEvent != null) {
            return this.currentFileWriteEvent.getStackTraceIndex();
        }
        if (this.currentFileOpenEvent != null) {
            return this.currentFileOpenEvent.getStackTraceIndex();
        }
        if (this.currentFileCloseEvent != null) {
            return this.currentFileCloseEvent.getStackTraceIndex();
        }
        return 0;
    }

    @Override
    public char getThreadIndex() {
        if (this.currentFileReadEvent != null) {
            return this.currentFileReadEvent.getThreadIndex();
        }
        if (this.currentFileWriteEvent != null) {
            return this.currentFileWriteEvent.getThreadIndex();
        }
        if (this.currentFileOpenEvent != null) {
            return this.currentFileOpenEvent.getThreadIndex();
        }
        if (this.currentFileCloseEvent != null) {
            return this.currentFileCloseEvent.getThreadIndex();
        }
        return '\u0000';
    }

    public IOOperations getIOOperationsValue() {
        if (this.it != null) {
            return this.it.getIOOperations();
        }
        return new IOOperations(this.currentFileOpenEvent != null ? (long)(this.isSynthetic(this.currentFileOpenEvent) ? 0 : 1) : 0L, this.currentFileCloseEvent != null ? 1L : 0L, this.currentFileReadEvent != null ? (long)this.currentFileReadEvent.getNrOfReadBytes() : 0L, this.currentFileWriteEvent != null ? (long)this.currentFileWriteEvent.getNrOfWrittenBytes() : 0L, this.currentFileReadEvent != null ? this.currentFileReadEvent.getDuration() : 0L, this.currentFileWriteEvent != null ? this.currentFileWriteEvent.getDuration() : 0L, this.currentFileReadEvent != null ? 1L : 0L, this.currentFileWriteEvent != null ? 1L : 0L);
    }

    public IODetails getDetails() {
        long fd = this.getFd();
        return new IODetails(fd, this.currentFileOpenEvent != null ? this.currentFileOpenEvent.getTimeStamp() : 0L, this.currentFileOpenEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentFileOpenEvent != null ? this.getThreadInfo().getNameUTF() : null, this.currentFileCloseEvent != null ? this.currentFileCloseEvent.getTimeStamp() : 0L, this.currentFileCloseEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentFileCloseEvent != null ? this.getThreadInfo().getNameUTF() : null);
    }

    public IOOperationsAndDetails getOperationsAndDetails() {
        long fd = this.getFd();
        return new IOOperationsAndDetails(fd, this.currentFileOpenEvent != null ? this.currentFileOpenEvent.getTimeStamp() : 0L, this.currentFileOpenEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentFileOpenEvent != null ? this.getThreadInfo().getNameUTF() : null, this.currentFileCloseEvent != null ? this.currentFileCloseEvent.getTimeStamp() : 0L, this.currentFileCloseEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentFileCloseEvent != null ? this.getThreadInfo().getNameUTF() : null, this.currentFileReadEvent != null ? (long)this.currentFileReadEvent.getNrOfReadBytes() : 0L, this.currentFileWriteEvent != null ? (long)this.currentFileWriteEvent.getNrOfWrittenBytes() : 0L, this.currentFileReadEvent != null ? this.currentFileReadEvent.getDuration() : 0L, this.currentFileWriteEvent != null ? this.currentFileWriteEvent.getDuration() : 0L, this.currentFileReadEvent != null ? 1L : 0L, this.currentFileWriteEvent != null ? 1L : 0L);
    }

    public UTF8String getFilename() {
        if (this.currentFileOpenEvent != null) {
            return this.currentFileOpenEvent.getFilename();
        }
        long fd = this.getFd();
        UTF8String retValue = this.fd2Filename.get(fd);
        return retValue == null ? UTF8Creator.create((String)"") : retValue;
    }

    public FileId getFileId() {
        return this.currentFileId;
    }

    private long getFd() {
        if (this.currentFileOpenEvent != null) {
            return this.currentFileOpenEvent.getFd();
        }
        if (this.currentFileReadEvent != null) {
            return this.currentFileReadEvent.getFd();
        }
        if (this.currentFileWriteEvent != null) {
            return this.currentFileWriteEvent.getFd();
        }
        if (this.currentFileCloseEvent != null) {
            return this.currentFileCloseEvent.getFd();
        }
        return -1L;
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        if (this.it.next()) {
            if (!this.reporter.report(this.it.getProgress())) {
                throw new OperationCanceledException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected int nextOrReadRaw() throws IOException {
        this.currentFileOpenEvent = null;
        this.currentFileReadEvent = null;
        this.currentFileWriteEvent = null;
        this.currentFileCloseEvent = null;
        try {
            if (this.readNextInitialEvent() || this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.currentFileOpenEvent == null && this.currentFileReadEvent == null && this.currentFileCloseEvent == null && this.currentFileWriteEvent == null) {
                    return 1;
                }
                if (this.currentFileOpenEvent != null && !this.appliesFileFilter(this.currentFileOpenEvent.getFilename(), this.currentFileOpenEvent.getId())) {
                    return 1;
                }
                if (this.currentFileReadEvent != null && !this.appliesFileFilter(this.fd2Filename.get(this.currentFileReadEvent.getFd()), this.currentFileReadEvent.getId())) {
                    return 1;
                }
                if (this.currentFileWriteEvent != null && !this.appliesFileFilter(this.fd2Filename.get(this.currentFileWriteEvent.getFd()), this.currentFileWriteEvent.getId())) {
                    return 1;
                }
                if (this.currentFileCloseEvent != null && !this.appliesFileFilter(this.fd2Filename.get(this.currentFileCloseEvent.getFd()), this.currentFileCloseEvent.getId())) {
                    return 1;
                }
                this.updateFileId();
                return 0;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    @Override
    protected ResourceName getDependentForIt() {
        return null;
    }

    public void handle(EnableIOTraceResponse response) {
    }

    public void handle(DisableIOTraceResponse response) {
    }

    public void handle(FileOpenEvent event) {
        this.currentFileOpenEvent = event;
        this.fd2Filename.put(event.getFd(), event.getFilename());
        if (this.initiallyOpenedFiles == null && event.getThreadIndex() == '\u0000' && event.getStackTraceIndex() == 0) {
            ++this.syntheticOpenEventsCount;
        }
    }

    public void handle(FileNotFoundEvent event) {
    }

    public void handle(FileReadEvent event) {
        this.currentFileReadEvent = event;
    }

    public void handle(FileWriteEvent event) {
        this.currentFileWriteEvent = event;
    }

    public void handle(FileCloseEvent event) {
        this.currentFileCloseEvent = event;
    }

    private boolean appliesFileFilter(UTF8String filename, long fileId) {
        return this.fileFilter == null || this.fileFilter.applies(filename, fileId);
    }

    private void updateFileId() {
        long id = -1L;
        if (this.currentFileOpenEvent != null) {
            id = this.currentFileOpenEvent.getId();
        } else if (this.currentFileReadEvent != null) {
            id = this.currentFileReadEvent.getId();
        } else if (this.currentFileWriteEvent != null) {
            id = this.currentFileWriteEvent.getId();
        } else if (this.currentFileCloseEvent != null) {
            id = this.currentFileCloseEvent.getId();
        }
        Long indexObj = this.id2Index.get(id);
        if (indexObj == null) {
            indexObj = this.nextIndex++;
            this.id2Index.put(id, indexObj);
        }
        long index = indexObj;
        this.currentFileId = new FileId(id, index);
    }

    public FileOpenEvent getFileOpenEvent() {
        return this.currentFileOpenEvent;
    }

    public FileCloseEvent getFileCloseEvent() {
        return this.currentFileCloseEvent;
    }

    public int getNrOfSyntheticOpenEvents() {
        return Math.max(0, this.initiallyOpenedFilesIndex) + this.syntheticOpenEventsCount;
    }

    private boolean readNextInitialEvent() {
        if (this.initiallyOpenedFilesIndex < 0) {
            assert (this.initiallyOpenedFiles == null);
            this.initiallyOpenedFiles = this.reader.getFileManager().getOpenEvents();
            this.initiallyOpenedFilesIndex = 0;
        }
        assert (this.initiallyOpenedFilesIndex >= 0);
        if (this.initiallyOpenedFiles == null) {
            return false;
        }
        if (this.initiallyOpenedFilesIndex >= this.initiallyOpenedFiles.length) {
            this.initiallyOpenedFiles = null;
            return false;
        }
        this.handle(this.initiallyOpenedFiles[this.initiallyOpenedFilesIndex++]);
        return true;
    }

    private boolean isSynthetic(FileOpenEvent event) {
        return this.initiallyOpenedFiles != null || event.getThreadIndex() == '\u0000' && event.getStackTraceIndex() == 0;
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }
}

