/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.io.event.FileCloseEvent;
import com.sap.jvm.profiling.io.event.FileOpenEvent;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.FilterByFileId;
import com.sap.jvm.profiling.snapshot.filter.FileFilter;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIterator;
import com.sap.jvm.profiling.snapshot.io.OpenFileFilter;
import java.io.IOException;
import java.util.HashMap;

public class OpenFileFilterImpl
extends AbstractResource
implements OpenFileFilter {
    private static final int VERSION = 0;
    private FilterByFileId filterElement;

    public OpenFileFilterImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        reader.readVersion(0, 0);
        this.filterElement = new FilterByFileId(reader);
    }

    private OpenFileFilterImpl(FilterByFileId filterElement, ResourceName name) {
        super(name);
        this.filterElement = filterElement;
    }

    public static OpenFileFilterImpl create(ResourceName name, ProgressReporter reporter) throws IOException, OperationCanceledException {
        IOValueIterator it = new IOValueIterator(name, reporter, I18n._s((String)"Searching for open files ... (<%> %)"));
        HashMap<Long, FileOpenEvent> openFiles = new HashMap<Long, FileOpenEvent>();
        while (it.next()) {
            FileCloseEvent fileCloseEvent;
            FileOpenEvent fileOpenEvent = it.getFileOpenEvent();
            if (fileOpenEvent != null) {
                openFiles.put(fileOpenEvent.getId(), fileOpenEvent);
            }
            if ((fileCloseEvent = it.getFileCloseEvent()) == null) continue;
            openFiles.remove(fileCloseEvent.getId());
        }
        long[] fileIds = new long[openFiles.size()];
        long[] fds = new long[openFiles.size()];
        long[] contIndex = new long[openFiles.size()];
        int i = 0;
        for (FileOpenEvent openEvent : openFiles.values()) {
            fileIds[i] = openEvent.getId();
            fds[i] = openEvent.getFd();
            contIndex[i] = i;
            ++i;
        }
        return new OpenFileFilterImpl(new FilterByFileId(fileIds, contIndex, fds), name);
    }

    public ResourceName[] getDependents() {
        return null;
    }

    public boolean isModifiable() {
        return false;
    }

    @Override
    public FileFilter getFilter() {
        return this.filterElement.getFilter();
    }

    @Override
    public long calculateWriteWork() {
        return 0L;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        this.filterElement.write(writer);
    }
}

