/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.io;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.io.IOValueIterator;
import com.sap.jvm.profiling.snapshot.io.IOOperations;
import com.sap.jvm.profiling.snapshot.io.StackIterator;
import com.sap.jvm.profiling.snapshot.io.StackStatistic;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import com.sap.jvm.util.pair.IntPair;
import java.io.IOException;

public final class StackStatisticImpl
extends AbstractResource
implements StackStatistic {
    private static final int VERSION = 2;
    private final SplitArray32 stackIndexToLogicalIndexMap = new SplitArray32();
    private final SplitArray32 logicalIndexToStackIndexMap = new SplitArray32();
    private final SplitArrayObject<IOOperations> logicalIndexToTime = new SplitArrayObject(0);
    private IOOperations totalIOOperations = IOOperations.EMPTY;
    private int nrOfEntries;

    public StackStatisticImpl(ResourceName name) {
        super(name);
    }

    public StackStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        reader.readVersion(2);
        int readNrOfEntries = reader.readInt32();
        reporter.setWork(I18n._s((String)"Reading the stack statistic ... (<%> %)"), (long)this.nrOfEntries);
        for (long i = 0L; i < (long)readNrOfEntries; ++i) {
            reporter.reportNextOrThrow();
            int stackIndex = reader.readInt32();
            IOOperations ioOperations = new IOOperations(reader);
            this.add(stackIndex, ioOperations);
        }
        assert (this.nrOfEntries == readNrOfEntries);
        this.finish();
    }

    public static Resource create(ResourceName name, ProgressReporter reporter) throws OperationCanceledException, IOException {
        IOValueIterator it = new IOValueIterator(name, reporter, I18n._s((String)"Analyzing the samples ... (<%> %)"));
        StackStatisticImpl result = new StackStatisticImpl(name);
        while (it.next()) {
            result.add(it.getStackIndex(), it.getValue());
        }
        result.finish();
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        writer.writeInt32(this.nrOfEntries);
        StackIteratorImpl it = this.getIterators(1)[0];
        reporter.setWork(I18n._s((String)"Writing the stack statistic ... (<%> %)"), (long)this.nrOfEntries);
        for (int i = 0; i < this.nrOfEntries; ++i) {
            reporter.reportNextOrThrow();
            boolean hasNext = it.next();
            assert (hasNext);
            writer.writeInt32(it.getStackIndex());
            it.getIOOperations().write(writer);
        }
    }

    @Override
    public long calculateWriteWork() {
        return this.nrOfEntries;
    }

    private void add(int stackIndex, IOOperations ioOperations) {
        this.totalIOOperations = this.totalIOOperations.getSum(ioOperations);
        this.stackIndexToLogicalIndexMap.resize(stackIndex + 1);
        int logicalIndex = this.stackIndexToLogicalIndexMap.get(stackIndex);
        if (logicalIndex == 0) {
            ++this.nrOfEntries;
            logicalIndex = this.nrOfEntries;
            this.stackIndexToLogicalIndexMap.set(stackIndex, logicalIndex);
            this.logicalIndexToStackIndexMap.resize(this.nrOfEntries + 1);
            this.logicalIndexToTime.resize(this.nrOfEntries + 1, (Object)IOOperations.EMPTY);
            this.logicalIndexToStackIndexMap.set(logicalIndex, stackIndex);
        }
        this.logicalIndexToTime.set(logicalIndex, (Object)((IOOperations)this.logicalIndexToTime.get(logicalIndex)).getSum(ioOperations));
    }

    private void finish() {
    }

    public long getNrOfEntries() {
        return this.nrOfEntries;
    }

    public StackIteratorImpl[] getIterators(int nrOfIterators) {
        StackIteratorImpl baseIterator;
        assert (nrOfIterators > 0);
        StackIteratorImpl[] result = new StackIteratorImpl[nrOfIterators];
        result[0] = baseIterator = new StackIteratorImpl(this, null);
        for (int i = 1; i < nrOfIterators; ++i) {
            result[i] = new StackIteratorImpl(this, baseIterator);
        }
        return result;
    }

    @Override
    public long getSize() {
        return this.nrOfEntries;
    }

    @Override
    public IOOperations getIOOperations() {
        assert (this.totalIOOperations != null);
        return this.totalIOOperations;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    public boolean isModifiable() {
        return false;
    }

    private IntPair getFromStackTraceArray(int startIndex, int maxToAdd, int offset, int[] stackIndices, IOOperations[] times) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = this.nrOfEntries + 1;
        for (int i = startIndex; i < maxIndex; ++i) {
            stackIndices[currOffset] = this.logicalIndexToStackIndexMap.get(i);
            times[currOffset] = (IOOperations)this.logicalIndexToTime.get(i);
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    public static final class StackIteratorImpl
    implements StackIterator {
        private static final int STORE_SIZE = 8192;
        private final StackStatisticImpl statistic;
        private long nrOfEntries;
        private final StackIteratorImpl baseIterator;
        private int stackTraceIndex;
        private final int[] stackStore;
        private final IOOperations[] ioOperationsStore;
        private int storeIndex;
        private int maxStoreIndex;
        private boolean isValid;

        public StackIteratorImpl(StackStatisticImpl statistic, StackIteratorImpl baseIterator) {
            this.statistic = statistic;
            this.stackStore = new int[8192];
            this.ioOperationsStore = new IOOperations[8192];
            for (int i = 0; i < 8192; ++i) {
                this.ioOperationsStore[i] = IOOperations.EMPTY;
            }
            this.baseIterator = baseIterator == null ? this : baseIterator;
            this.maxStoreIndex = 0;
            this.isValid = true;
            this.stackTraceIndex = 1;
        }

        @Override
        public int getStackIndex() {
            assert (this.isValid);
            return this.stackStore[this.storeIndex];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean next() {
            ++this.storeIndex;
            if (this.storeIndex < this.maxStoreIndex) {
                return true;
            }
            StackIteratorImpl stackIteratorImpl = this.baseIterator;
            synchronized (stackIteratorImpl) {
                this.storeIndex = 0;
                IntPair result = this.statistic.getFromStackTraceArray(this.baseIterator.stackTraceIndex, 8192, 0, this.stackStore, this.ioOperationsStore);
                this.maxStoreIndex = result.getFirst();
                this.baseIterator.stackTraceIndex = result.getSecond();
                this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                if (this.maxStoreIndex > 0) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public long getProgress() {
            return this.baseIterator.nrOfEntries;
        }

        @Override
        public long getMaxProgress() {
            return this.statistic.nrOfEntries;
        }

        @Override
        public IOOperations getIOOperations() {
            assert (this.isValid);
            return this.ioOperationsStore[this.storeIndex];
        }
    }
}

