/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.MptInvocationAndTimeIterator;
import com.sap.jvm.profiling.snapshot.mpt.MethodParameterSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class MethodParameterSnapshotImpl
extends SnapshotImpl
implements MethodParameterSnapshot {
    private ResourceName resourceName;
    private long nrOfInvocations;
    private final List<MethodParameterSpec> specs;
    private final List<MethodParameterMethodToTraceEvent> methodsToTrace;

    public static MethodParameterSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long nrOfInvocations = reader.readInt64();
        ProfilingSession session = reader.getSession();
        int nrOfSpecs = reader.readInt8();
        ArrayList<MethodParameterSpec> specs = new ArrayList<MethodParameterSpec>();
        for (int i = 0; i < nrOfSpecs; ++i) {
            specs.add(session.readMethodParameterSpec(reader));
        }
        int nrOfMethodsToTrace = reader.hasNext() ? reader.readInt32() : 0;
        ArrayList<MethodParameterMethodToTraceEvent> methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
        for (int i = 0; i < nrOfMethodsToTrace; ++i) {
            methodsToTrace.add(session.readMethodToTrace(reader));
        }
        MethodParameterSnapshotImpl snapshot = new MethodParameterSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, nrOfInvocations, specs, methodsToTrace, startTimestamp, endTimestamp, isVirtual, null);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public MethodParameterSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, long nrOfInvocations, List<MethodParameterSpec> specs, List<MethodParameterMethodToTraceEvent> methodsToTrace, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, MethodParameterSnapshot parent) {
        super(SnapshotType.METHOD_PARAMETER_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.resourceName = resourceName;
        this.nrOfInvocations = nrOfInvocations;
        this.specs = specs;
        this.methodsToTrace = methodsToTrace;
    }

    @Override
    public long getNrOfInvocations() {
        return this.nrOfInvocations;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public List<MethodParameterSpec> getParameterSpecs() {
        return this.specs;
    }

    @Override
    public List<MethodParameterMethodToTraceEvent> getMethodsToTrace() {
        return this.methodsToTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MethodParameterApplyErrorEvent> getApplyErrors(ProgressReporter reporter) throws OperationCanceledException {
        LinkedList<MethodParameterApplyErrorEvent> retValue = new LinkedList<MethodParameterApplyErrorEvent>();
        ProfilingReader reader = this.getEventReader(reporter);
        MptEventHandler handler = new MptEventHandler(retValue, null);
        reader.registerMethodParameterEventHandler((MethodParameterEventHandler)handler);
        try {
            while (reader.nextPacket() != null) {
            }
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, (String)"I/O error during reading snapshot events.");
        }
        finally {
            reader.close();
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MethodParameterNearMissEvent> getNearMisses(ProgressReporter reporter) throws OperationCanceledException {
        LinkedList<MethodParameterNearMissEvent> retValue = new LinkedList<MethodParameterNearMissEvent>();
        ProfilingReader reader = this.getEventReader(reporter);
        MptEventHandler handler = new MptEventHandler(null, retValue);
        reader.registerMethodParameterEventHandler((MethodParameterEventHandler)handler);
        try {
            while (reader.nextPacket() != null) {
            }
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, (String)"I/O error during reading snapshot events.");
        }
        finally {
            reader.close();
        }
        return retValue;
    }

    public MptInvocationAndTimeIterator getMptEventIterator(ProgressReporter progressReporter, String message) throws IOException {
        return new MptInvocationAndTimeIterator(this, this.resourceName, progressReporter, message);
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        if (this.nrOfInvocations >= 0L) {
            return;
        }
        this.nrOfInvocations = 0L;
        MptInvocationAndTimeIterator it = this.getMptEventIterator(reporter, I18n._s((String)"Analyzing the invocations ... (<%> %)"));
        try {
            while (it.next()) {
                this.nrOfInvocations += it.getValue().getInvocations().getTotalInvocations();
            }
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Failed to analyze the invocations");
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.getNrOfInvocations());
        writer.writeInt8(this.specs.size());
        for (MethodParameterSpec spec : this.specs) {
            writer.writeMethodParameterSpec(spec);
        }
        writer.writeInt32(this.methodsToTrace.size());
        for (MethodParameterMethodToTraceEvent methodToTrace : this.methodsToTrace) {
            writer.writeMethodToTrace(methodToTrace);
        }
    }

    private class MptEventHandler
    implements MethodParameterEventHandler {
        private List<MethodParameterApplyErrorEvent> applyErrorList;
        private List<MethodParameterNearMissEvent> nearMissList;

        public MptEventHandler(List<MethodParameterApplyErrorEvent> applyErrorList, List<MethodParameterNearMissEvent> nearMissList) {
            this.applyErrorList = applyErrorList;
            this.nearMissList = nearMissList;
        }

        public void handle(DisableMethodParameterTraceResponse response) {
        }

        public void handle(EnableMethodParameterTraceResponse response) {
        }

        public void handle(MethodParameterApplyErrorEvent event) {
            if (this.applyErrorList != null) {
                this.applyErrorList.add(event);
            }
        }

        public void handle(MethodParameterEntryEvent event) {
        }

        public void handle(MethodParameterExitEvent event) {
        }

        public void handle(MethodParameterNearMissEvent event) {
            if (this.nearMissList != null) {
                this.nearMissList.add(event);
            }
        }

        public boolean providesReturnValuesInEntryEvents() {
            return false;
        }

        public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) {
            assert (false);
            return null;
        }
    }
}

