/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.MptInvocationAndTimeIterator;
import com.sap.jvm.profiling.snapshot.impl.util.series.AbstractValueTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.mpt.InvocationsAndTime;
import com.sap.jvm.profiling.snapshot.mpt.MptTimeSeriesCollection;
import java.io.IOException;

public class MptTimeSeriesCollectionImpl
extends AbstractValueTimeSeriesCollection<InvocationsAndTime>
implements MptTimeSeriesCollection {
    private InvocationsAndTime emptyValue;
    private long ongoingCalls = 0L;
    private long previousOngoingCalls = 0L;

    public MptTimeSeriesCollectionImpl(ResourceName name) throws IOException {
        super(name);
    }

    public MptTimeSeriesCollectionImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reader, reporter, I18n._s((String)"Reading the time series ... (<%> %)"));
    }

    public static MptTimeSeriesCollectionImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        MptTimeSeriesCollectionImpl result = new MptTimeSeriesCollectionImpl(name);
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        MptInvocationAndTimeIterator iterator = new MptInvocationAndTimeIterator(snapshot, name, reporter, I18n._s((String)"Creating the time series ... (<%> %)"));
        result.emptyValue = iterator.getEmptyValue();
        result.createTimeSeries(iterator);
        return result;
    }

    @Override
    protected void getValuesForValue(long[] values, long elapsed, InvocationsAndTime value) {
        values[0] = value.getInvocations().getTotalInvocations() * 1000L / elapsed;
        values[1] = value.getCpuTime() * 1000L / elapsed;
        values[2] = value.getElapsedTime() * 1000L / elapsed;
        values[3] = value == this.emptyValue ? this.previousOngoingCalls : this.ongoingCalls;
        this.previousOngoingCalls = this.ongoingCalls;
    }

    @Override
    protected void handleValue(InvocationsAndTime value) {
        if (value == this.emptyValue) {
            return;
        }
        assert (value.getInvocations().getTotalInvocations() >= 0L && value.getInvocations().getTotalInvocations() <= 1L);
        this.ongoingCalls = value.getInvocations().getTotalInvocations() == 0L ? --this.ongoingCalls : ++this.ongoingCalls;
    }
}

