/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import java.util.regex.Pattern;

public class InputArrayDefValidator
extends InputValidator {
    private final Pattern MOD_ARRAY = Pattern.compile("^\\[\\s*[-]?\\d+\\s*\\]$");
    private final Pattern MOD_ARRAY_IDX = Pattern.compile("^[-]?\\d*$");
    private final Pattern MOD_ARRAY_ERR = Pattern.compile("^\\[.*\\].+$");
    private static final InputValidator.InputPart LENGTH_RETURN = new InputValidator.InputPart();
    private InputValidator.InputPart[] parts = new InputValidator.InputPart[1];

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.MPT_ARRAY_VALIDATOR;
    }

    @Override
    protected void validate(String source) {
        String pattern = source.trim();
        this.parts[0] = null;
        int length = pattern.length();
        if (length == 0) {
            this.setValidIn();
            return;
        }
        if (pattern.equals("length")) {
            this.setInComplete();
            this.parts[0] = LENGTH_RETURN;
        } else if (this.MOD_ARRAY.matcher(pattern).matches()) {
            this.setInComplete();
        } else {
            int idxEnd;
            String idxStr;
            if (pattern.charAt(0) != '[') {
                int start = source.indexOf(pattern.charAt(0));
                this.setErrMsg(I18n._s((String)"'[' expected!"), start, pattern.length());
                return;
            }
            this.setAdvancedState();
            if (this.MOD_ARRAY_ERR.matcher(pattern).matches()) {
                int start = source.indexOf(93) + 1;
                this.setErrMsg(I18n._s((String)"nothing expected after the ']'"), start, source.length() - start);
                return;
            }
            if (length > 1 && !this.MOD_ARRAY_IDX.matcher(idxStr = (idxEnd = pattern.indexOf(93)) > 0 ? pattern.substring(1, idxEnd).trim() : pattern.substring(1).trim()).matches()) {
                int start = source.indexOf(idxStr.charAt(0));
                this.setErrMsg(I18n._s((String)"invalid array index, can only be negative or positive digit."), start, idxStr.length());
                return;
            }
            this.setValidIn();
        }
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        return this.parts[0] == null ? null : this.parts;
    }

    static {
        LENGTH_RETURN.update("int", InputValidator.ContentType.RETURN_CLASS);
    }
}

