/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import java.util.regex.Pattern;

public class InputCastDefValidator
extends InputValidator {
    private final Pattern CAST = Pattern.compile("^\\(\\s*(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)\\s*\\)$");
    private final Pattern CAST2 = Pattern.compile("^(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)$");
    private final Pattern BASE = Pattern.compile("^\\(.*\\)\\s*$");
    private final Pattern BASE2 = Pattern.compile("^\\([^\\)]+$");
    private final Pattern CAST_ERR = Pattern.compile("^.*\\)(\\s*[\\S]+)+$");
    private InputValidator.InputPart[] castType = new InputValidator.InputPart[]{new InputValidator.InputPart(InputValidator.ContentType.RETURN_CLASS)};

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.MPT_CAST_VALIDATOR;
    }

    @Override
    protected void validate(String source) {
        String pattern = source.trim();
        if (pattern.length() == 0) {
            this.setValidIn();
            return;
        }
        if (pattern.equals("class")) {
            this.setInComplete();
            this.castType[0].update("java.lang.Class", InputValidator.ContentType.RETURN_CLASS);
        } else if (pattern.equals("id")) {
            this.setInComplete();
            this.castType[0].update("long", InputValidator.ContentType.RETURN_CLASS);
        } else if (this.CAST.matcher(pattern).matches()) {
            this.setInComplete();
            int start = source.indexOf(40) + 1;
            String type = source.substring(start, source.indexOf(41)).trim();
            this.castType[0].update(type, start);
        } else {
            if (this.BASE.matcher(pattern).matches()) {
                this.setAdvancedState();
                int start = source.indexOf(40) + 1;
                int end = source.indexOf(41);
                String typeSource = source.substring(start, end);
                String type = typeSource.trim();
                int typeTrim = type.length() > 0 ? typeSource.indexOf(type.charAt(0)) : start;
                this.castType[0].update(type, start + typeTrim);
                if (type.length() == 0) {
                    this.setErrMsg(I18n._s((String)"missing the cast type '(...)'"), start - 1, 2);
                    return;
                }
                if (!CLASS.matcher(type).matches()) {
                    this.setErrMsg(I18n._s((String)"invalid cast type specification!"), start + typeTrim, type.length());
                    return;
                }
            } else if (this.BASE2.matcher(pattern).matches()) {
                String type;
                this.setAdvancedState();
                int start = source.indexOf(40) + 1;
                String string = type = source.substring(start);
                type = type.trim();
                int typeTrim = string.indexOf(type.charAt(0));
                this.castType[0].update(type, start + typeTrim);
                if (!this.CAST2.matcher(type).matches()) {
                    this.setErrMsg(I18n._s((String)"invalid cast type specification!"), start + typeTrim, type.length());
                    return;
                }
            } else {
                if (pattern.charAt(0) != '(') {
                    int start = source.indexOf(pattern.charAt(0));
                    this.setErrMsg(I18n._s((String)"missing the '('"), start, pattern.length());
                    return;
                }
                if (this.CAST_ERR.matcher(pattern).matches()) {
                    String rest;
                    int start = source.indexOf(41) + 1;
                    String string = rest = source.substring(start);
                    rest = rest.trim();
                    this.setErrMsg(I18n._s((String)"nothing expected after the ')'"), start += string.indexOf(rest.charAt(0)), rest.length());
                    return;
                }
            }
            this.setValidIn();
        }
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        return this.castType;
    }
}

