/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InputFieldDefValidator
extends InputValidator {
    private final Pattern FIELD = Pattern.compile("^(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)\\s+([a-zA-Z_$][\\w$]*)$");
    private final Pattern CLASS2 = Pattern.compile("(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)");
    private final Pattern BASE = Pattern.compile("^.+\\s+.+$");
    private final Pattern BASE_ERR = Pattern.compile("^[\\S]+\\s+[\\S]+(\\s+[\\S]+)+$");
    private final Pattern SPLIT = Pattern.compile("\\s+");
    private InputValidator.InputPart[] fieldType = new InputValidator.InputPart[]{new InputValidator.InputPart(InputValidator.ContentType.RETURN_CLASS)};

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.MPT_FIELD_VALIDATOR;
    }

    @Override
    protected void validate(String source) {
        String pattern = source.trim();
        if (pattern.length() == 0) {
            this.setValidIn();
            return;
        }
        if (this.FIELD.matcher(pattern).matches()) {
            this.setInComplete();
            this.updateFieldType(source);
        } else {
            if (this.BASE.matcher(pattern).matches()) {
                if (this.BASE_ERR.matcher(pattern).matches()) {
                    this.setErrMsg(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"the field definition has to be composed of the two parts class+name!"), 0, source.length());
                    return;
                }
                String[] parts = this.SPLIT.split(pattern);
                if (!CLASS.matcher(parts[0]).matches()) {
                    int start = source.indexOf(parts[0].charAt(0));
                    this.setErrMsg(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"the field class definition is invalid!"), start, parts[0].length());
                    return;
                }
                this.setAdvancedState();
                if (!NAME.matcher(parts[1]).matches()) {
                    int start = source.indexOf(parts[1]);
                    this.setErrMsg(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"the field name definition is invalid!"), start, parts[1].length());
                    return;
                }
            } else if (!CLASS.matcher(pattern).matches()) {
                int start = source.indexOf(pattern.charAt(0));
                this.setErrMsg(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"invalid class definition!"), start, source.length() - start);
                return;
            }
            this.setValidIn();
        }
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        return this.fieldType;
    }

    private void updateFieldType(String input) {
        Matcher pos = this.CLASS2.matcher(input);
        pos.find();
        this.fieldType[0].update(pos.group(), pos.start());
    }
}

