/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;

public class InputInternModifierDefValidator
extends InputValidator {
    private InputValidator.InputPart modifier = new InputValidator.InputPart(InputValidator.ContentType.INTERNAL_MODIFIER);
    private InputValidator.InputPart returnType = new InputValidator.InputPart(InputValidator.ContentType.RETURN_CLASS);
    private InputValidator.InputPart[] parts = new InputValidator.InputPart[]{this.modifier, this.returnType};
    private boolean forArray;

    public InputInternModifierDefValidator(boolean forArray) {
        this.forArray = forArray;
    }

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.INT_MOD_DEF_VALIDATOR;
    }

    @Override
    protected void validate(String source) {
        String pattern = source.trim();
        this.parts[0].reset();
        this.parts[1].reset();
        int length = pattern.length();
        if (length == 0) {
            this.setValidIn();
            return;
        }
        if (pattern.equals("class")) {
            this.setInComplete();
            this.parts[0].update(pattern, 0);
            this.parts[1].update("java.lang.Class", 0);
            return;
        }
        if (this.forArray && pattern.equals("length") || pattern.equals("id")) {
            this.setInComplete();
            this.parts[0].update(pattern, 0);
            this.parts[1].update("int", 0);
            return;
        }
        if (pattern.charAt(0) == '%' && pattern.substring(1).indexOf(37) == -1) {
            this.setValidIn();
            return;
        }
        this.setErrMsg(I18n._s((String)"Invalid internal modifier"), 0, pattern.length());
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        return this.parts[0] == null ? null : this.parts;
    }
}

