/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class InputMethodDefValidator
extends com.sap.jvm.profiling.snapshot.filter.InputMethodDefValidator {
    private static final String CONSTRUCTOR = "<init>";
    private static final String STATIC_CONSTRUCTOR = "<clinit>";
    private static final Pattern BASE = Pattern.compile("^.*\\(.*\\).*$");
    private static final Pattern BASE2 = Pattern.compile("^.*\\(.*$");
    private static final Pattern PARAMS = Pattern.compile(",");
    private InputValidator.InputPart[] classMethodAndRetType = new InputValidator.InputPart[]{new InputValidator.InputPart(InputValidator.ContentType.METHOD_CLASS), new InputValidator.InputPart(InputValidator.ContentType.METHOD_NAME), new InputValidator.InputPart(InputValidator.ContentType.RETURN_CLASS)};
    private List<InputValidator.InputPart> paramTypes = new ArrayList<InputValidator.InputPart>();
    String className;
    String methodName;
    String signature;
    String returnClassName;

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.METHOD_DEF_VALIDATOR;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getReturnClassName() {
        return this.returnClassName;
    }

    private void updateParameter(int idx, String param, int start) {
        if (idx > this.paramTypes.size()) {
            throw new IllegalArgumentException(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"invalid parameter index!"));
        }
        String paramDef = param;
        if (param.endsWith("...")) {
            paramDef = param.substring(0, param.length() - 3) + "[]";
        }
        if (this.paramTypes.size() == idx) {
            InputValidator.InputPart newType = new InputValidator.InputPart(InputValidator.ContentType.PARAM_CLASS);
            newType.update(paramDef, start);
            this.paramTypes.add(newType);
        } else {
            this.paramTypes.get(idx).update(paramDef, start);
        }
    }

    private void updateParametersCount(int size) {
        int toBeRemoved = this.paramTypes.size() - size;
        for (int i = 0; i < toBeRemoved; ++i) {
            this.paramTypes.remove(this.paramTypes.size() - 1);
        }
    }

    @Override
    protected void validate(String source) {
        String pattern = source.trim();
        this.className = null;
        this.methodName = null;
        this.signature = null;
        this.returnClassName = null;
        if (pattern.length() == 0) {
            this.setValidIn();
            this.classMethodAndRetType[0].reset();
            this.classMethodAndRetType[1].reset();
            this.classMethodAndRetType[2].reset();
            this.updateParametersCount(0);
            return;
        }
        int trimOffset = source.indexOf(pattern.charAt(0));
        String classMethodName = null;
        int sigOffset = pattern.indexOf(40) + 1;
        int retOffset = pattern.indexOf(41) + 1;
        InputValidator.InputPart error = null;
        if (BASE.matcher(pattern).matches()) {
            classMethodName = pattern.substring(0, sigOffset - 1);
            this.signature = pattern.substring(sigOffset, retOffset - 1);
            this.returnClassName = pattern.substring(retOffset);
        } else if (BASE2.matcher(pattern).matches()) {
            classMethodName = pattern.substring(0, sigOffset - 1);
            this.signature = pattern.substring(sigOffset);
            this.classMethodAndRetType[2].reset();
        } else {
            classMethodName = pattern;
            this.classMethodAndRetType[2].reset();
            this.updateParametersCount(0);
        }
        if (classMethodName.indexOf(46) > 0) {
            int methodNameOffset = classMethodName.lastIndexOf(46) + 1;
            this.className = classMethodName.substring(0, methodNameOffset - 1);
            this.methodName = classMethodName.substring(methodNameOffset).trim();
            this.classMethodAndRetType[0].update(this.className, trimOffset);
            this.classMethodAndRetType[1].update(this.methodName, trimOffset + methodNameOffset);
            if (!CLASS.matcher(this.className).matches()) {
                error = new InputValidator.InputPart(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"invalid method class specification!"), trimOffset, this.className.length());
            }
            if (!(error != null || this.methodName.length() <= 0 || CONSTRUCTOR.equals(this.methodName) || STATIC_CONSTRUCTOR.equals(this.methodName) || NAME.matcher(this.methodName).matches())) {
                error = new InputValidator.InputPart(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"invalid method name specification!"), trimOffset + methodNameOffset, this.methodName.length());
            }
        } else {
            this.classMethodAndRetType[0].update(classMethodName, trimOffset);
            this.classMethodAndRetType[1].update(classMethodName, trimOffset);
            if (classMethodName != pattern) {
                error = new InputValidator.InputPart(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"missing either the class or method definition!"), trimOffset, classMethodName.length());
            }
        }
        String trimedSig = null;
        if (this.signature != null && (trimedSig = this.signature.trim()).length() > 0) {
            String[] paramClasses = PARAMS.split(this.signature);
            int i = 0;
            int idx = 0;
            for (String paramClass : paramClasses) {
                int paramOffset = trimOffset + sigOffset + i;
                String tmpParam = paramClass.trim();
                if (tmpParam.length() > 0) {
                    int start = paramOffset + paramClass.indexOf(tmpParam.charAt(0));
                    this.updateParameter(idx, tmpParam, start);
                    if (error == null && !PR_CLASS.matcher(tmpParam).matches()) {
                        error = new InputValidator.InputPart(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"invalid parameter class definition!"), start, tmpParam.length());
                    }
                } else {
                    this.updateParameter(idx, "", paramOffset);
                    error = new InputValidator.InputPart(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"empty parameter class definition!"), paramOffset - 1, paramClass.length() + 1);
                }
                i += paramClass.length() + 1;
                ++idx;
            }
            this.updateParametersCount(idx);
            if (error == null && trimedSig.charAt(trimedSig.length() - 1) == ',') {
                error = new InputValidator.InputPart(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"missing next parameter definition!"), trimOffset + sigOffset + this.signature.length() - 1, 1);
            }
        } else {
            this.updateParametersCount(0);
        }
        if (this.returnClassName != null) {
            String tmpRetType = this.returnClassName.trim();
            if (tmpRetType.length() > 0) {
                int trimRetOffset = this.returnClassName.indexOf(tmpRetType.charAt(0));
                int start = trimOffset + retOffset + trimRetOffset;
                this.classMethodAndRetType[2].update(tmpRetType, start);
                if (error == null && !CLASS.matcher(tmpRetType).matches()) {
                    error = new InputValidator.InputPart(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"invalid return type definition!"), start, tmpRetType.length());
                }
            } else {
                this.classMethodAndRetType[2].reset();
            }
            if (error == null) {
                this.setInComplete();
                return;
            }
        } else {
            this.classMethodAndRetType[2].reset();
        }
        if (error == null) {
            this.setValidIn();
        } else {
            this.setErrMsg(error.getContent(), error.getStart(), error.getLength());
        }
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        if (this.paramTypes.isEmpty()) {
            return this.classMethodAndRetType;
        }
        InputValidator.InputPart[] result = new InputValidator.InputPart[3 + this.paramTypes.size()];
        result[0] = this.classMethodAndRetType[0];
        result[1] = this.classMethodAndRetType[1];
        result[2] = this.classMethodAndRetType[2];
        for (int i = 3; i < result.length; ++i) {
            result[i] = this.paramTypes.get(i - 3);
        }
        return result;
    }
}

