/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;

public class InputMethodNameDefValidator
extends InputValidator {
    private String pattern;
    private InputValidator.InputPart methodNameType = new InputValidator.InputPart(InputValidator.ContentType.METHOD_NAME);

    @Override
    protected void validate(String in) {
        this.pattern = in.trim();
        this.methodNameType.update(this.pattern, 0, this.pattern.length());
        if (!NAME.matcher(this.pattern).matches()) {
            this.setErrMsg(I18n._s((String)"Invalid method name definition!"), in.indexOf(this.pattern), this.pattern.length());
            return;
        }
        this.setInComplete();
        this.setValidIn();
    }

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.METHOD_NAME_VALIDATOR;
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        InputValidator.InputPart[] inputPartArray;
        if (this.pattern == null) {
            inputPartArray = null;
        } else {
            InputValidator.InputPart[] inputPartArray2 = new InputValidator.InputPart[1];
            inputPartArray = inputPartArray2;
            inputPartArray2[0] = this.methodNameType;
        }
        return inputPartArray;
    }
}

