/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputArrayDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputCastDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputFieldDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputInternModifierDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputModifierMethodDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputStaticMethodValidator;

public class InputModifierDefValidator
extends InputValidator {
    private static final String BOOLEAN = "boolean";
    private static final String BYTE = "byte";
    private static final String CHAR = "char";
    private static final String DOUBLE = "double";
    private static final String FLOAT = "float";
    private static final String INT = "int";
    private static final String LONG = "long";
    private static final String SHORT = "short";
    private static final String VOID = "void";
    private final InputValidator[] ARRAY_CLASS_CHAIN = new InputValidator[]{new InputInternModifierDefValidator(true), new InputArrayDefValidator(), new InputCastDefValidator(), new InputModifierMethodDefValidator(), new InputStaticMethodValidator(), new InputFieldDefValidator()};
    private final InputValidator[] CLASS_CHAIN = new InputValidator[]{new InputInternModifierDefValidator(false), new InputCastDefValidator(), new InputModifierMethodDefValidator(), new InputStaticMethodValidator(), new InputFieldDefValidator()};
    private final InputValidator.InputPart[] PARENT_TYPE = new InputValidator.InputPart[]{new InputValidator.InputPart(InputValidator.ContentType.RETURN_CLASS)};
    private String parentType;
    private InputValidator currentValidator;

    public void setParentType(String type) {
        if (type == null || type.trim().length() == 0) {
            this.parentType = null;
            return;
        }
        this.parentType = !InputValidator.CLASS.matcher(type).matches() ? null : type;
    }

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return this.currentValidator == null ? InputValidatorIdentifier.UNKNOWN : this.currentValidator.getIdentifier();
    }

    @Override
    protected void validate(String source) {
        if (source.trim().length() == 0) {
            this.setValidIn();
            return;
        }
        if (this.parentType == null) {
            this.setErrMsg(I18n._s((String)"invalid parent type!"));
            return;
        }
        if (InputModifierDefValidator.isPrimitive(this.parentType)) {
            this.setErrMsg(I18n._s((String)"the parent type could not be primitive!"));
            return;
        }
        if (this.parentType.endsWith("[]")) {
            this.processValidatorChain(source, this.ARRAY_CLASS_CHAIN);
            if (this.currentValidator.getRecognizedParts() == null) {
                this.PARENT_TYPE[0].update(this.parentType.substring(0, this.parentType.lastIndexOf(91)), InputValidator.ContentType.RETURN_CLASS);
            }
        } else {
            this.processValidatorChain(source, this.CLASS_CHAIN);
        }
        if (this.currentValidator.isInputComplete() && this.currentValidator instanceof InputStaticMethodValidator) {
            InputValidator.InputPart param = this.currentValidator.getRecognizedParts()[2];
            if (!this.getSimpleType(this.parentType).equals(this.getSimpleType(param.getContent()))) {
                this.setErrMsg(I18n._s((String)"The parameter type of the static method is invalid!"), param.getStart(), param.getLength());
            }
        }
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        if (this.currentValidator != null) {
            InputValidator.InputPart[] result = this.currentValidator.getRecognizedParts();
            if (this.currentValidator instanceof InputArrayDefValidator && result == null) {
                return this.PARENT_TYPE;
            }
            return result;
        }
        return new InputValidator.InputPart[0];
    }

    private void processValidatorChain(String input, InputValidator[] chain) {
        for (int i = 0; i < chain.length; ++i) {
            InputValidator item = chain[i];
            item.process(input);
            if (item.isInputComplete()) {
                this.setInComplete();
                this.currentValidator = item;
                return;
            }
            if (!item.isValidInput()) {
                if (!item.reachedAdvancedSate() && i + 1 < chain.length) continue;
                this.setErrMsg(item.getErrorMessage(), item.getErrStart(), item.getErrLength());
                this.currentValidator = item;
                return;
            }
            this.setValidIn();
            this.currentValidator = item;
            return;
        }
    }

    public static boolean isPrimitive(String type) {
        return InputModifierDefValidator.isVoid(type) || InputModifierDefValidator.isPrimitiveWithoutVoid(type);
    }

    public static boolean isPrimitiveWithoutVoid(String type) {
        return BOOLEAN.equals(type) || INT.equals(type) || LONG.equals(type) || BYTE.equals(type) || CHAR.equals(type) || DOUBLE.equals(type) || FLOAT.equals(type) || SHORT.equals(type);
    }

    public static boolean isVoid(String type) {
        return type != null ? VOID.equals(type.trim()) : false;
    }

    public String getSimpleType(String type) {
        if (type.startsWith("java.lang.")) {
            return type.substring(10);
        }
        return type;
    }
}

