/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InputModifierMethodDefValidator
extends InputValidator {
    protected static final String P_METHOD = "([a-zA-Z_$][\\w$]*)\\s*\\(\\s*\\)\\s*(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)";
    public static final Pattern METHOD = Pattern.compile("^([a-zA-Z_$][\\w$]*)\\s*\\(\\s*\\)\\s*(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)$");
    private static final Pattern BASE = Pattern.compile("^.*\\(.*\\).*$");
    private static final Pattern BASE2 = Pattern.compile("^.*\\(.*$");
    private static final Pattern P4 = Pattern.compile("[\\S&&[^\\(]]+");
    private static final Pattern P6 = Pattern.compile("\\).+$");
    private InputValidator.InputPart[] nameAndRetTypetype = new InputValidator.InputPart[]{new InputValidator.InputPart(InputValidator.ContentType.METHOD_NAME), new InputValidator.InputPart(InputValidator.ContentType.RETURN_CLASS)};

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.MPT_MODIFIER_METHOD_VALIDATOR;
    }

    private void updateMethodName(String input) {
        Matcher pos = P4.matcher(input);
        pos.find();
        this.nameAndRetTypetype[0].update(pos.group().trim(), pos.start());
    }

    private void updateReturTypes(String input) {
        Matcher pos = P6.matcher(input);
        pos.find();
        int start = pos.start();
        String type = pos.group().substring(1).trim();
        if (type.length() > 0) {
            this.nameAndRetTypetype[1].update(type, start += pos.group().indexOf(type.charAt(0)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void validate(String source) {
        String pattern = source.trim();
        if (pattern.length() == 0) {
            this.setValidIn();
            return;
        }
        if (METHOD.matcher(pattern).matches()) {
            this.setInComplete();
            this.updateMethodName(source);
            this.updateReturTypes(source);
            return;
        }
        int trimOffset = source.indexOf(pattern.charAt(0));
        this.updateMethodName(source);
        if (BASE.matcher(pattern).matches()) {
            String name = pattern.substring(0, pattern.indexOf(40)).trim();
            if (!NAME.matcher(name).matches()) {
                this.setErrMsg(I18n._s((String)"invalid method name!"), trimOffset, name.length());
                return;
            }
            this.setAdvancedState();
            int start = pattern.indexOf(40) + 1;
            int end = pattern.indexOf(41);
            String sig = pattern.substring(start, end).trim();
            if (sig.length() > 0) {
                this.setErrMsg(I18n._s((String)"the signature has to be empty!"), trimOffset + start, end - start);
                return;
            }
            int retTrimOffset = pattern.indexOf(41) + 1;
            String retType = pattern.substring(retTrimOffset);
            String tmp = retType.trim();
            if (tmp.length() <= 0) {
                start = trimOffset + retTrimOffset;
                this.setErrMsg(I18n._s((String)"missing return type!"), start, source.length() - start);
                return;
            }
            retTrimOffset += retType.indexOf(tmp.charAt(0));
            retType = tmp;
            this.nameAndRetTypetype[1].update(retType, trimOffset + retTrimOffset);
            if (!CLASS.matcher(retType).matches()) {
                this.setErrMsg(I18n._s((String)"invalid return type def!"), trimOffset + retTrimOffset, retType.length());
                return;
            }
        } else {
            if (BASE2.matcher(pattern).matches()) {
                String name = pattern.substring(0, pattern.indexOf(40)).trim();
                if (!NAME.matcher(name).matches()) {
                    this.setErrMsg(I18n._s((String)"invalid method name!"), trimOffset, name.length());
                    return;
                }
                this.setAdvancedState();
                int start = trimOffset + pattern.indexOf(40);
                this.setErrMsg(I18n._s((String)"missing )!"), start, source.length() - start);
                return;
            }
            String name = pattern;
            if (!NAME.matcher(name).matches()) {
                this.setErrMsg(I18n._s((String)"invalid method name!"), trimOffset, name.length());
                return;
            }
        }
        this.setValidIn();
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        return this.nameAndRetTypetype;
    }
}

