/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputModifierDefValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InputStaticMethodWithoutReturnClassValidator
extends InputValidator {
    protected static final String P_METHOD = "(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)\\.([a-zA-Z_$][\\w$]*)\\s*\\(\\s*(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)\\s*\\)\\s*";
    public static final Pattern METHOD = Pattern.compile("^(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)\\.([a-zA-Z_$][\\w$]*)\\s*\\(\\s*(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)\\s*\\)\\s*$");
    protected static final Pattern METHOD_ERR = Pattern.compile("^\\s+[\\S]+\\s*$");
    protected static final Pattern CLASS_ERR = Pattern.compile("^\\s*[\\S]+\\s+$");
    private static final Pattern BASE1 = Pattern.compile("^.*\\(.*\\).*$");
    private static final Pattern BASE2 = Pattern.compile("^.*\\(.*$");
    private static final Pattern SIG_ERR = Pattern.compile("^.*(\\s.*).*$");
    private static final Pattern P1 = Pattern.compile(".*\\(");
    private static final Pattern P2 = Pattern.compile("\\(.[^\\)]*");
    private InputValidator.InputPart[] types = new InputValidator.InputPart[]{new InputValidator.InputPart(InputValidator.ContentType.METHOD_CLASS), new InputValidator.InputPart(InputValidator.ContentType.METHOD_NAME), new InputValidator.InputPart(InputValidator.ContentType.PARAM_CLASS)};

    @Override
    public InputValidatorIdentifier getIdentifier() {
        return InputValidatorIdentifier.MPT_MODIFIER_STATIC_METHOD_VALIDATOR;
    }

    @Override
    protected void validate(String source) {
        String pattern = source.trim();
        if (pattern.length() == 0) {
            this.setValidIn();
            return;
        }
        int trimOffset = source.indexOf(pattern.charAt(0));
        if (METHOD.matcher(pattern).matches()) {
            String sigType;
            this.setInComplete();
            Matcher m = P1.matcher(pattern);
            m.find();
            int idx = m.group().lastIndexOf(46);
            String clazz = m.group().substring(0, idx);
            this.types[0].update(clazz, trimOffset);
            String method = m.group().substring(idx + 1, m.group().length() - 1).trim();
            this.types[1].update(method, trimOffset + idx + 1);
            m = P2.matcher(pattern);
            m.find();
            String string = sigType = m.group().substring(1);
            sigType = sigType.trim();
            int sigTypeTrim = string.indexOf(sigType.charAt(0));
            this.types[2].update(sigType, trimOffset + m.start() + sigTypeTrim + 1);
            if (InputModifierDefValidator.isPrimitive(sigType)) {
                this.setErrMsg(I18n._s((String)"The parameter type cannot be a primitive type!"), this.types[2].getStart(), this.types[2].getLength());
                return;
            }
        } else {
            int start;
            String signatur;
            String method;
            String retType = null;
            int sigOffset = pattern.indexOf(40) + 1;
            int retTypeOffset = pattern.indexOf(41) + 1;
            if (BASE1.matcher(pattern).matches()) {
                retType = pattern.substring(retTypeOffset).trim();
                if (retType.length() == 0) {
                    retType = null;
                }
                method = pattern.substring(0, pattern.indexOf(40));
                signatur = pattern.substring(sigOffset, pattern.indexOf(41));
                this.setAdvancedState();
            } else if (BASE2.matcher(pattern).matches()) {
                method = pattern.substring(0, pattern.indexOf(40));
                signatur = pattern.substring(sigOffset);
                this.setAdvancedState();
            } else {
                method = pattern;
                signatur = null;
            }
            String string = method;
            method = method.trim();
            int methodTrim = string.indexOf(method.charAt(0));
            if (method.lastIndexOf(46) > 0) {
                int idx = method.lastIndexOf(46);
                start = trimOffset + methodTrim;
                String clazz = method.substring(0, idx);
                if (CLASS_ERR.matcher(clazz).matches()) {
                    this.setErrMsg(I18n._s((String)"invalid method class definition!"), trimOffset, clazz.length());
                    return;
                }
                clazz = clazz.trim();
                this.types[0].update(clazz, start);
                if (!CLASS.matcher(clazz).matches()) {
                    this.setErrMsg(I18n._s((String)"invalid method class definition!"), start, idx);
                    return;
                }
                if (METHOD_ERR.matcher(method = method.substring(idx + 1)).matches()) {
                    start = trimOffset + idx + 1;
                    this.setErrMsg(I18n._s((String)"invalid method name definition!"), start, method.length());
                    return;
                }
                this.types[1].update(method, start + idx + 1);
                if (method.length() > 0 && !NAME.matcher(method).matches()) {
                    start = trimOffset + idx + 1;
                    this.setErrMsg(I18n._s((String)"invalid method name definition!"), start, method.length());
                    return;
                }
            } else {
                this.types[0].update(method, trimOffset);
                if (signatur == null) {
                    if (!CLASS.matcher(method).matches()) {
                        this.setErrMsg(I18n._s((String)"invalid method class definition!"), trimOffset, method.length());
                        return;
                    }
                } else {
                    this.setErrMsg(I18n._s((String)"missing method name!"), trimOffset, method.length());
                    return;
                }
            }
            if (signatur != null) {
                String tmpSig = signatur.trim();
                if (tmpSig.length() == 0) {
                    start = trimOffset + sigOffset - 1;
                    this.setErrMsg(I18n._s((String)"empty signature!"), start, 1);
                    return;
                }
                int sigTrimOffset = signatur.indexOf(tmpSig.charAt(0));
                signatur = tmpSig;
                int start2 = trimOffset + sigOffset + sigTrimOffset;
                if (SIG_ERR.matcher(signatur).matches()) {
                    this.setErrMsg(I18n._s((String)"only one parameter is accepted!"), start2, signatur.length());
                    return;
                }
                this.types[2].update(tmpSig, start2);
                if (!CLASS.matcher(signatur).matches()) {
                    this.setErrMsg(I18n._s((String)"invalid signature type definition!"), start2, signatur.length());
                    return;
                }
                if (InputModifierDefValidator.isPrimitive(signatur)) {
                    this.setErrMsg(I18n._s((String)"the signature cannot be a primitive type!"), start2, signatur.length());
                    return;
                }
            }
            if (retType != null) {
                this.setErrMsg(I18n._s((String)"no return type expected!"), retTypeOffset, retType.length());
                return;
            }
            this.setValidIn();
        }
    }

    @Override
    public InputValidator.InputPart[] getRecognizedParts() {
        return this.types;
    }
}

