/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.type.ClassObjectManager;
import com.sap.jvm.profiling.core.type.MethodObjectManager;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.parameters.BooleanParameter;
import com.sap.jvm.profiling.method.parameters.ByteParameter;
import com.sap.jvm.profiling.method.parameters.CharParameter;
import com.sap.jvm.profiling.method.parameters.ClassCastExceptionParameter;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.DoubleParameter;
import com.sap.jvm.profiling.method.parameters.EnableFailedParameter;
import com.sap.jvm.profiling.method.parameters.ExceptionInCallParameter;
import com.sap.jvm.profiling.method.parameters.FloatParameter;
import com.sap.jvm.profiling.method.parameters.IndexOutOfBoundsParameter;
import com.sap.jvm.profiling.method.parameters.IntParameter;
import com.sap.jvm.profiling.method.parameters.LongParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.NullInCallParameter;
import com.sap.jvm.profiling.method.parameters.NullParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.method.parameters.ShortParameter;
import com.sap.jvm.profiling.method.parameters.StringParameter;
import com.sap.jvm.profiling.method.parameters.UnknownParameter;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.InputStreamResourceReader;
import com.sap.jvm.profiling.resource.OutputStreamResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.util.AbstractId2DataOracle;
import com.sap.jvm.profiling.snapshot.impl.util.LongWriteRandomAccessFile;
import com.sap.jvm.profiling.snapshot.mpt.Elements;
import com.sap.jvm.profiling.snapshot.mpt.MethodParameterSnapshotBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class MPTExitValueOracle
extends AbstractId2DataOracle<ArrayList<Parameter>> {
    private static final String TEMPORARY_INDEX_FILE = "mpt_index";
    private static final String TEMPORARY_DATA_FILE = "mpt_data";
    private static final AtomicLong id = new AtomicLong();
    private final ClassObjectManager clazzManager;
    private final MethodObjectManager methodManager;

    private MPTExitValueOracle(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter, TEMPORARY_INDEX_FILE + id.incrementAndGet(), TEMPORARY_DATA_FILE + id.incrementAndGet(), AbstractId2DataOracle.ReadingPolicy.SIMPLE_READER);
        this.clazzManager = name.getSession().getClassObjectManager();
        this.methodManager = name.getSession().getMethodObjectManager();
    }

    public MPTExitValueOracle(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(reader, name, reporter, TEMPORARY_INDEX_FILE + id.incrementAndGet(), TEMPORARY_DATA_FILE + id.incrementAndGet());
        this.clazzManager = name.getSession().getClassObjectManager();
        this.methodManager = name.getSession().getMethodObjectManager();
    }

    public static MPTExitValueOracle get(ResourceName name, ProgressReporter reporter) throws IOException {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(name.getSession());
        Snapshot snapshot = manager.getSnapshot(name);
        if (!(snapshot instanceof MethodParameterSnapshotBase)) {
            return null;
        }
        MethodParameterSnapshotBase mptSnapshot = (MethodParameterSnapshotBase)((Object)snapshot);
        boolean hasReturnValues = false;
        for (MethodParameterSpec spec : mptSnapshot.getParameterSpecs()) {
            if (spec.getIndex() != -2) continue;
            hasReturnValues = true;
        }
        if (!hasReturnValues) {
            return null;
        }
        ResourceName snapshotName = snapshot.asResourceName();
        ResourceNameElement[] elements = snapshotName.getElements();
        ResourceName baseName = name.getResourceManager().createResourceName(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            baseName = baseName.addElement(elements[i]);
            if (elements[i] instanceof SnapshotEndTag) break;
        }
        ResourceName oracleName = baseName.addElement((ResourceNameElement)new Elements.CreateMptExitValueOracle());
        return (MPTExitValueOracle)name.getResourceManager().get(oracleName, reporter);
    }

    public static MPTExitValueOracle create(ResourceName name, ProgressReporter reporter) throws IOException {
        return new MPTExitValueOracle(name, reporter);
    }

    @Override
    protected AbstractId2DataOracle.Creator getCreator(OutputStreamResourceWriter out, LongWriteRandomAccessFile index) {
        return new AbstractId2DataOracle.Creator(out, index){

            @Override
            protected void prepareForFinish() {
            }

            @Override
            protected void handleImpl(ProfilingPacket packet) throws IOException {
                if (packet instanceof MethodParameterExitEvent) {
                    MethodParameterExitEvent event = (MethodParameterExitEvent)packet;
                    long currentId = event.getId();
                    if (currentId == -1L) {
                        return;
                    }
                    int nrOfReturnValues = 0;
                    MethodParameters params = event.getParameters();
                    for (int i = 0; i < params.getNrOfParameters(); ++i) {
                        if (params.getSpec(i).getIndex() != -2) continue;
                        ++nrOfReturnValues;
                    }
                    if (nrOfReturnValues > 0) {
                        ArrayList<Parameter> returnValues = new ArrayList<Parameter>(nrOfReturnValues);
                        for (int i = 0; i < params.getNrOfParameters(); ++i) {
                            if (params.getSpec(i).getIndex() != -2) continue;
                            returnValues.add(params.getParameter(i));
                        }
                        this.writeValue(new AbstractId2DataOracle.Entry(currentId, returnValues));
                        this.writeIndex(currentId);
                    }
                } else if (packet instanceof MethodParameterEntryEvent) {
                    MethodParameterEntryEvent event = (MethodParameterEntryEvent)packet;
                    assert (event.getId() != -1L);
                    this.createDummyIndex(event.getId());
                }
            }

            @Override
            protected void finishImpl(long currentId) throws IOException {
                this.writeValue(new AbstractId2DataOracle.Entry(currentId, new ArrayList()));
                this.writeIndex(currentId);
            }
        };
    }

    @Override
    protected void writeData(ResourceWriter writer, AbstractId2DataOracle.Entry<ArrayList<Parameter>> data) throws IOException {
        writer.writeInt64(data.getId());
        ArrayList<Parameter> params = data.getValue();
        if (params.size() < 128) {
            writer.writeInt8(params.size());
        } else {
            writer.writeInt8(-1);
            writer.writeInt32(params.size());
        }
        for (Parameter param : params) {
            param.write(writer);
        }
    }

    @Override
    protected AbstractId2DataOracle.Entry<ArrayList<Parameter>> readData(InputStreamResourceReader reader) throws IOException {
        long currentId = reader.readInt64();
        int len = reader.readInt8();
        if (len == -1) {
            len = reader.readInt32();
        }
        ArrayList<BooleanParameter> parameters = new ArrayList<BooleanParameter>(len);
        for (int i = 0; i < len; ++i) {
            BooleanParameter parameter;
            byte tag = reader.readInt8();
            if (tag == ParameterType.BOOLEAN.getTag()) {
                parameter = new BooleanParameter(reader.readBoolean());
            } else if (tag == ParameterType.BYTE.getTag()) {
                parameter = new ByteParameter(reader.readInt8());
            } else if (tag == ParameterType.SHORT.getTag()) {
                parameter = new ShortParameter(reader.readInt16());
            } else if (tag == ParameterType.CHAR.getTag()) {
                parameter = new CharParameter(reader.readUint16());
            } else if (tag == ParameterType.INT.getTag()) {
                parameter = new IntParameter(reader.readInt32());
            } else if (tag == ParameterType.LONG.getTag()) {
                parameter = new LongParameter(reader.readInt64());
            } else if (tag == ParameterType.FLOAT.getTag()) {
                parameter = new FloatParameter(reader.readFloat());
            } else if (tag == ParameterType.DOUBLE.getTag()) {
                parameter = new DoubleParameter(reader.readDouble());
            } else if (tag == ParameterType.STRING.getTag()) {
                byte[] utf = new byte[reader.readUint16()];
                reader.readBytes(utf);
                parameter = new StringParameter(utf);
            } else if (tag == ParameterType.CLASS.getTag()) {
                parameter = new ClassParameter(reader.getSession().getClassObjectManager().getClassObject(reader.readInt32()));
            } else if (tag == ParameterType.NULL.getTag()) {
                parameter = new NullParameter();
            } else if (tag == ParameterType.NULL_INVOCATION_DURING_CALL.getTag()) {
                parameter = new NullInCallParameter();
            } else if (tag == ParameterType.INDEX_OUT_OF_BOUNDS.getTag()) {
                parameter = new IndexOutOfBoundsParameter();
            } else if (tag == ParameterType.CLASS_CAST_EXCEPTION.getTag()) {
                parameter = new ClassCastExceptionParameter();
            } else if (tag == ParameterType.ENABLE_FAILED.getTag()) {
                parameter = new EnableFailedParameter();
            } else if (tag == ParameterType.UNKNOWN.getTag()) {
                parameter = new UnknownParameter();
            } else if (tag == ParameterType.METHOD.getTag()) {
                parameter = new MethodParameter(reader.getSession().getMethodObjectManager().getMethodObject(reader.readInt32()), reader.getSession().getClassObjectManager().getClassObject(reader.readInt32()));
            } else {
                assert (tag == ParameterType.EXCEPTION_DURING_CALL.getTag());
                parameter = new ExceptionInCallParameter();
            }
            parameters.add(parameter);
        }
        return new AbstractId2DataOracle.Entry<ArrayList<Parameter>>(currentId, parameters);
    }

    @Override
    protected String[] getMessages() {
        return new String[]{I18n._s((String)"Analyzing the return values ... (<%> %)"), I18n._s((String)"Reading the return values ... (<%> %)"), I18n._s((String)"Writing the return values ... (<%> %)")};
    }
}

