/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.mpt.util;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.MPTExitValueOracle;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.AbstractId2DataOracle;
import com.sap.jvm.profiling.snapshot.mpt.CpuAndElapsedTime;
import java.io.IOException;
import java.util.ArrayList;

public class MptTimeIterator
extends AbstractValueIterator<CpuAndElapsedTime>
implements MethodParameterEventHandler {
    private final ProfilingReader reader = this.getEventReader();
    private final ThreadManager threadManager;
    private final ProgressReporter reporter;
    private MethodParameterEntryEvent entry;
    private MethodParameterExitEvent exit;
    private ThreadInfo lastDelayedThreadInfo;
    private final long[] lastTimeStamps;
    private final long[] lastCpuTimes;
    private final boolean[] hasLastEvent;
    private CpuAndElapsedTime value;
    private char threadIndex;
    private int stackIndex;
    private final long elapsedTimeOverhead;
    private final AbstractId2DataOracle.DataReader<ArrayList<Parameter>> oracleReader;

    public MptTimeIterator(Snapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws IOException {
        super(name, snapshot, reporter);
        this.reporter = reporter;
        MPTExitValueOracle oracle = MPTExitValueOracle.get(snapshot.asResourceName(), reporter);
        this.oracleReader = oracle == null ? null : oracle.getReader(this.getSession());
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.threadManager = this.reader.getThreadManager();
        this.reader.registerMethodParameterEventHandler((MethodParameterEventHandler)this);
        this.elapsedTimeOverhead = Math.max(0L, name.getSession().getSystemInfo().timeStampOverhead());
        this.lastTimeStamps = new long[131072];
        this.lastCpuTimes = new long[131072];
        this.hasLastEvent = new boolean[131072];
    }

    @Override
    protected ResourceName getDependentForIt() {
        return null;
    }

    @Override
    public int getStackIndex() {
        return this.stackIndex;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public CpuAndElapsedTime getValue() {
        return this.value;
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int nextOrReadRaw() throws IOException {
        try {
            if (this.lastDelayedThreadInfo != null) {
                this.lastDelayedThreadInfo.undoEntryStackChanges();
                this.lastDelayedThreadInfo = null;
            }
            if (this.reader.nextPacket() != null) {
                this.reporter.reportNextOrThrow();
                if (this.entry != null) {
                    ThreadInfo threadInfo;
                    this.threadIndex = this.entry.getThreadIndex();
                    this.stackIndex = this.entry.getStackTraceIndex();
                    this.lastDelayedThreadInfo = threadInfo = this.threadManager.getThreadInfo(this.threadIndex);
                    this.lastDelayedThreadInfo.hideTopEntryEvent();
                    long currTimeStamp = this.entry.getTimeStamp();
                    long currCpuTime = this.entry.getCpuTime();
                    if (this.hasLastEvent[this.threadIndex]) {
                        long elapsed = Math.max(0L, currTimeStamp - this.lastTimeStamps[this.threadIndex] - this.elapsedTimeOverhead);
                        long cpu = Math.max(0L, currCpuTime - this.lastCpuTimes[this.threadIndex]);
                        this.value = CpuAndElapsedTime.create(cpu, elapsed);
                        this.lastTimeStamps[this.threadIndex] = currTimeStamp;
                        this.lastCpuTimes[this.threadIndex] = currCpuTime;
                        this.entry = null;
                        return 0;
                    }
                    this.value = null;
                    this.hasLastEvent[this.threadIndex] = true;
                    this.lastTimeStamps[this.threadIndex] = currTimeStamp;
                    this.lastCpuTimes[this.threadIndex] = currCpuTime;
                    this.entry = null;
                    return this.value != null ? 0 : 1;
                }
                if (this.exit != null) {
                    boolean isBottomOfStack;
                    this.threadIndex = this.exit.getThreadIndex();
                    this.stackIndex = this.exit.getEntryEvent() == null ? 0 : this.exit.getEntryEvent().getStackTraceIndex();
                    ThreadInfo threadInfo = this.threadManager.getThreadInfo(this.threadIndex);
                    boolean bl = isBottomOfStack = threadInfo.getEntryEventTop() >= 0;
                    assert (this.lastDelayedThreadInfo == null);
                    this.lastDelayedThreadInfo = threadInfo;
                    this.lastDelayedThreadInfo.unhideLastPoppedEntryEvent();
                    long currTimeStamp = this.exit.getTimeStamp();
                    long currCpuTime = this.exit.getCpuTime();
                    if (!this.hasLastEvent[this.threadIndex]) {
                        this.value = CpuAndElapsedTime.EMPTY;
                    } else {
                        long elapsed = Math.max(0L, currTimeStamp - this.lastTimeStamps[this.threadIndex] - this.elapsedTimeOverhead);
                        long cpu = Math.max(0L, currCpuTime - this.lastCpuTimes[this.threadIndex]);
                        this.value = CpuAndElapsedTime.create(cpu, elapsed);
                    }
                    if (isBottomOfStack) {
                        this.lastTimeStamps[this.threadIndex] = currTimeStamp;
                        this.lastCpuTimes[this.threadIndex] = currCpuTime;
                    } else {
                        this.hasLastEvent[this.threadIndex] = false;
                    }
                    this.exit = null;
                    return 0;
                }
                return 1;
            }
        }
        catch (IOException e) {
            this.reader.close();
            throw e;
        }
        this.reader.close();
        return 2;
    }

    public void handle(EnableMethodParameterTraceResponse response) {
    }

    public void handle(DisableMethodParameterTraceResponse response) {
    }

    public void handle(MethodParameterEntryEvent event) {
        this.entry = event;
    }

    public void handle(MethodParameterExitEvent event) {
        this.exit = event;
    }

    public void handle(MethodParameterNearMissEvent event) {
    }

    public void handle(MethodParameterApplyErrorEvent event) {
    }

    public boolean providesReturnValuesInEntryEvents() {
        return this.oracleReader != null;
    }

    public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) throws IOException {
        return this.oracleReader.getData(event.getId());
    }

    public static MptTimeIterator get(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        return new MptTimeIterator(snapshot, name, reporter, message);
    }

    @Override
    public CpuAndElapsedTime getEmptyValue() {
        return CpuAndElapsedTime.EMPTY;
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }
}

