/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfTotalAndOtherValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfTotalAndOtherValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkDetailsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkOperationsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.SocketIdColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfTotalAndOtherStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkDetailsSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkOperationsSerializer;
import com.sap.jvm.profiling.snapshot.net.CalledDetailedSocketStatistic;
import com.sap.jvm.profiling.snapshot.net.CallingDetailedSocketStatistic;
import com.sap.jvm.profiling.snapshot.net.NetworkDetails;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import com.sap.jvm.profiling.snapshot.resource.SocketId;
import java.io.IOException;

public final class CalledCallingDetailedSocketStatisticImpl
extends SelfTotalAndOtherValueStatisticImpl<SocketId, NetworkOperations, NetworkDetails>
implements CalledDetailedSocketStatistic,
CallingDetailedSocketStatistic {
    protected CalledCallingDetailedSocketStatisticImpl(ResourceName name) {
        super(name, new SocketIdColumn(), new NetworkOperationsColumnImpl(), new NetworkOperationsColumnImpl(), new NetworkOperationsSerializer(), new NetworkDetailsColumnImpl(), new NetworkDetailsSerializer());
    }

    public CalledCallingDetailedSocketStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the detailed socket statistic ... (<%> %)"), reporter);
    }

    public static CalledCallingDetailedSocketStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        NetworkValueIterator it = new NetworkValueIterator(name, reporter, I18n._s((String)"Creating the detailed socket statistic ... (<%> %)"));
        CalledCallingDetailedSocketStatisticImpl result = new CalledCallingDetailedSocketStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the detailed socket statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends SelfTotalAndOtherStatisticCreator<SocketId, NetworkOperations, NetworkDetails> {
        private Creator() {
        }

        @Override
        protected SelfTotalAndOtherValueStatisticCollector<SocketId, NetworkOperations, NetworkDetails> getCollector(ValueIterator<NetworkOperations> rawIt) throws IOException {
            NetworkValueIterator it = (NetworkValueIterator)rawIt;
            SelfTotalAndOtherValueStatisticCollector<SocketId, NetworkOperations, NetworkDetails> collector = new SelfTotalAndOtherValueStatisticCollector<SocketId, NetworkOperations, NetworkDetails>(NetworkOperations.EMPTY, NetworkDetails.EMPTY);
            while (it.next()) {
                SocketId socketId = it.getSocketId();
                NetworkOperations value = it.getValue();
                NetworkDetails other = it.getNetworkDetails();
                collector.addTotal(socketId, value);
                collector.addOther(socketId, other);
                collector.add(value, other);
                if (!it.hasSelfRoot()) continue;
                collector.addSelf(socketId, value);
            }
            return collector;
        }
    }
}

