/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkConnectionColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkOperationsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkOperationsSerializer;
import com.sap.jvm.profiling.snapshot.net.CalledSocketStatistic;
import com.sap.jvm.profiling.snapshot.net.CallingSocketStatistic;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import java.io.IOException;

public final class CalledCallingSocketStatisticImpl
extends SelfAndTotalValueStatisticImpl<NetworkConnection, NetworkOperations>
implements CalledSocketStatistic,
CallingSocketStatistic {
    protected CalledCallingSocketStatisticImpl(ResourceName name) {
        super(name, new NetworkConnectionColumnImpl(), new NetworkOperationsColumnImpl(), new NetworkOperationsColumnImpl(), new NetworkOperationsSerializer());
    }

    public CalledCallingSocketStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the socket statistic ... (<%> %)"), reporter);
    }

    public static CalledCallingSocketStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        NetworkValueIterator it = new NetworkValueIterator(name, reporter, I18n._s((String)"Creating the socket statistic ... (<%> %)"), true);
        CalledCallingSocketStatisticImpl result = new CalledCallingSocketStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the socket statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends SelfAndTotalStatisticCreator<NetworkConnection, NetworkOperations> {
        private Creator() {
        }

        @Override
        protected SelfAndTotalValueStatisticCollector<NetworkConnection, NetworkOperations> getCollector(ValueIterator<NetworkOperations> rawIt) throws IOException {
            NetworkValueIterator it = (NetworkValueIterator)rawIt;
            SelfAndTotalValueStatisticCollector<NetworkConnection, NetworkOperations> collector = new SelfAndTotalValueStatisticCollector<NetworkConnection, NetworkOperations>(NetworkOperations.EMPTY);
            while (it.next()) {
                NetworkConnection connection = it.getNetworkConnection();
                NetworkOperations value = it.getValue();
                collector.addTotal(connection, value);
                collector.add(value);
                if (!it.hasSelfRoot()) continue;
                collector.addSelf(connection, value);
            }
            return collector;
        }
    }
}

