/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.net.CalledMethodTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CallingMethodTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.MethodLocationSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkOperationsSerializer;
import com.sap.jvm.profiling.snapshot.net.CallingMethodTree;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import java.io.IOException;

public final class CallingMethodTreeImpl
extends SelfAndTotalValueTreeImpl<MethodLocation, NetworkOperations>
implements CallingMethodTree {
    protected CallingMethodTreeImpl(ResourceName name) {
        super(name, new MethodLocationSerializer(), new NetworkOperationsSerializer());
    }

    public CallingMethodTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, reporter, I18n._s((String)"Reading the method tree ... (<%> %)"));
    }

    public static CallingMethodTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        NetworkValueIterator[] its = NetworkValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the method tree ... (<%> %)"), false);
        CallingMethodTreeImpl tree = new CallingMethodTreeImpl(name);
        new CallingMethodTreeCreator<NetworkOperations>().fillIn(tree, new CalledMethodTreeImpl.TreePruner(), its);
        return tree;
    }

    @Override
    public void createChildren(SelfAndTotalValueTreeNode<MethodLocation, NetworkOperations> node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        NetworkValueIterator[] its = new NetworkValueIterator[]{new NetworkValueIterator(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"))};
        new CallingMethodTreeCreator<NetworkOperations>().setChildren(new CalledMethodTreeImpl.TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void createSubNodes(SelfAndTotalValueTreeNode<MethodLocation, NetworkOperations> node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        NetworkValueIterator[] its = new NetworkValueIterator[]{new NetworkValueIterator(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"))};
        new CallingMethodTreeCreator<NetworkOperations>().setSubNodes(new CalledMethodTreeImpl.TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the method tree ... (<%> %)"));
    }
}

