/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.net.NetOperationsAndDetailsIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkOperationsAndDetailsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.SocketIdColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkOperationsAndDetailsSerializer;
import com.sap.jvm.profiling.snapshot.net.DetailedSocketStatistic;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.resource.SocketId;
import java.io.IOException;

public final class DetailedSocketStatisticImpl
extends ValueStatisticImpl<SocketId, NetworkOperationsAndDetails>
implements DetailedSocketStatistic {
    protected DetailedSocketStatisticImpl(ResourceName name) {
        super(name, new SocketIdColumn(), new NetworkOperationsAndDetailsColumnImpl(), new NetworkOperationsAndDetailsSerializer());
    }

    public DetailedSocketStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the detailed socket statistic ... (<%> %)"), reporter);
    }

    public static DetailedSocketStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        NetOperationsAndDetailsIterator it = new NetOperationsAndDetailsIterator(name, reporter, I18n._s((String)"Creating the detailed socket statistic ... (<%> %)"));
        DetailedSocketStatisticImpl result = new DetailedSocketStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the detailed socket statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<SocketId, NetworkOperationsAndDetails> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<SocketId, NetworkOperationsAndDetails> getCollector(ValueIterator<NetworkOperationsAndDetails> rawIt) throws IOException {
            NetOperationsAndDetailsIterator it = (NetOperationsAndDetailsIterator)rawIt;
            ValueStatisticCollector<SocketId, NetworkOperationsAndDetails> collector = new ValueStatisticCollector<SocketId, NetworkOperationsAndDetails>(NetworkOperationsAndDetails.EMPTY);
            while (it.next()) {
                collector.add(it.getSocketId(), it.getValue());
                collector.add(it.getValue());
            }
            return collector;
        }
    }
}

