/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.net.NetOperationsAndLatenciesIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkHostColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkOperationsAndLatenciesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkOperationsAndLatenciesSerializer;
import com.sap.jvm.profiling.snapshot.net.HostStatistic;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatencies;
import java.io.IOException;

public final class HostStatisticImpl
extends ValueStatisticImpl<NetworkHost, NetworkOperationsAndLatencies>
implements HostStatistic {
    protected HostStatisticImpl(ResourceName name) {
        super(name, new NetworkHostColumnImpl(), new NetworkOperationsAndLatenciesColumnImpl(), new NetworkOperationsAndLatenciesSerializer());
    }

    public HostStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the host statistic ... (<%> %)"), reporter);
    }

    public static HostStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        NetOperationsAndLatenciesIterator it = new NetOperationsAndLatenciesIterator(name, reporter, I18n._s((String)"Creating the host statistic ... (<%> %)"));
        HostStatisticImpl result = new HostStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the host statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<NetworkHost, NetworkOperationsAndLatencies> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<NetworkHost, NetworkOperationsAndLatencies> getCollector(ValueIterator<NetworkOperationsAndLatencies> rawIt) throws IOException {
            NetOperationsAndLatenciesIterator it = (NetOperationsAndLatenciesIterator)rawIt;
            ValueStatisticCollector<NetworkHost, NetworkOperationsAndLatencies> collector = new ValueStatisticCollector<NetworkHost, NetworkOperationsAndLatencies>(NetworkOperationsAndLatencies.EMPTY);
            while (it.next()) {
                collector.add(it.getNetworkHost(), it.getValue());
                collector.add(it.getValue());
            }
            return collector;
        }
    }
}

