/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkValueIteratorBase;
import com.sap.jvm.profiling.snapshot.impl.net.StackStatisticImpl;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.net.NetworkSnapshot;
import com.sap.jvm.profiling.snapshot.net.StackIterator;
import java.io.IOException;

public class NetOperationsAndDetailsIterator
extends NetworkValueIteratorBase<NetworkOperationsAndDetails> {
    public NetOperationsAndDetailsIterator(Snapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super((NetworkSnapshot)snapshot, name, reporter, message, false);
    }

    public NetOperationsAndDetailsIterator(ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(name, reporter, message, false);
    }

    public NetOperationsAndDetailsIterator(StackIterator it, ResourceName name, ProgressReporter reporter) {
        super(it, name, reporter);
    }

    public static NetOperationsAndDetailsIterator getEventIterator(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        return NetOperationsAndDetailsIterator.getIterators(name, 1, reporter, message, true)[0];
    }

    public static NetOperationsAndDetailsIterator[] getIterators(ResourceName name, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        return NetOperationsAndDetailsIterator.getIterators(name, name.getSession().getNrOfThreads(), reporter, message, usesEvents);
    }

    public static NetOperationsAndDetailsIterator[] getIterators(ResourceName name, int nrOfIterators, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        ProfilingSession session = name.getSession();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(session).getSnapshot(name);
        if (usesEvents || NetOperationsAndDetailsIterator.needsEventIteration(name)) {
            return new NetOperationsAndDetailsIterator[]{new NetOperationsAndDetailsIterator(snapshot, name, reporter, message)};
        }
        ResourceName sName = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateStackStatistic());
        StackStatisticImpl statistic = (StackStatisticImpl)session.getResourceManager().get(sName, reporter);
        if (statistic == null) {
            throw new OperationCanceledException();
        }
        StackStatisticImpl.StackIteratorImpl[] baseIterators = statistic.getIterators(nrOfIterators);
        NetOperationsAndDetailsIterator[] result = new NetOperationsAndDetailsIterator[baseIterators.length];
        ProgressReporter[] dummyReporters = reporter.getChildren(nrOfIterators - 1);
        result[0] = new NetOperationsAndDetailsIterator(baseIterators[0], name, reporter);
        for (int i = 1; i < result.length; ++i) {
            result[i] = new NetOperationsAndDetailsIterator(baseIterators[i], name, dummyReporters[i - 1]);
        }
        reporter.setWork(message, result[0].it.getMaxProgress());
        return result;
    }

    @Override
    public NetworkOperationsAndDetails getEmptyValue() {
        return NetworkOperationsAndDetails.EMPTY;
    }

    @Override
    public NetworkOperationsAndDetails getValue() {
        return this.getNetworkOperationsAndDetails();
    }
}

