/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.net.event.IpAddressUtil;
import com.sap.jvm.profiling.net.event.SocketAcceptEvent;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.net.event.SocketCloseEvent;
import com.sap.jvm.profiling.net.event.SocketConnectEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.resource.InputStreamResourceReader;
import com.sap.jvm.profiling.resource.OutputStreamResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkConnectionAndType;
import com.sap.jvm.profiling.snapshot.impl.util.AbstractId2DataOracle;
import com.sap.jvm.profiling.snapshot.impl.util.LongWriteRandomAccessFile;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class NetworkConnectionOracle
extends AbstractId2DataOracle<NetworkConnectionAndType> {
    private static final String TEMPORARY_INDEX_FILE = "network_connection_index";
    private static final String TEMPORARY_DATA_FILE = "network_connection_data";

    private NetworkConnectionOracle(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter, TEMPORARY_INDEX_FILE, TEMPORARY_DATA_FILE, AbstractId2DataOracle.ReadingPolicy.CACHING_READER);
    }

    public NetworkConnectionOracle(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(reader, name, reporter, TEMPORARY_INDEX_FILE, TEMPORARY_DATA_FILE);
    }

    public static NetworkConnectionOracle get(ResourceName name, ProgressReporter reporter) throws IOException {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(name.getSession());
        Snapshot snapshot = manager.getSnapshot(name);
        ResourceName snapshotName = snapshot.asResourceName();
        ResourceNameElement[] elements = snapshotName.getElements();
        ResourceName baseName = name.getResourceManager().createResourceName(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            baseName = baseName.addElement(elements[i]);
            if (elements[i] instanceof SnapshotEndTag) break;
        }
        ResourceName oracleName = baseName.addElement((ResourceNameElement)new Elements.CreateNetworkConnectionOracle());
        return (NetworkConnectionOracle)name.getResourceManager().get(oracleName, reporter);
    }

    public static NetworkConnectionOracle create(ResourceName name, ProgressReporter reporter) throws IOException {
        return new NetworkConnectionOracle(name, reporter);
    }

    @Override
    protected void writeData(ResourceWriter writer, AbstractId2DataOracle.Entry<NetworkConnectionAndType> data) throws IOException {
        writer.writeInt64(data.getId());
        IpAddressUtil.write((ResourceWriter)writer, (IpAddress)data.getValue().getConnection().getLocalAddress());
        writer.writeUint16(data.getValue().getConnection().getLocalPort());
        IpAddressUtil.write((ResourceWriter)writer, (IpAddress)data.getValue().getConnection().getRemoteAddress());
        writer.writeUint16(data.getValue().getConnection().getRemotePort());
        writer.writeBoolean(data.getValue().getConnection().isStreamSocket());
        writer.writeInt8(data.getValue().getSide().getValue());
    }

    @Override
    protected AbstractId2DataOracle.Entry<NetworkConnectionAndType> readData(InputStreamResourceReader reader) throws IOException {
        long id = reader.readInt64();
        IpAddress localAddress = IpAddressUtil.read((ResourceReader)reader);
        char localPort = reader.readUint16();
        IpAddress remoteAddress = IpAddressUtil.read((ResourceReader)reader);
        char remotePort = reader.readUint16();
        boolean isStreamSocket = reader.readBoolean();
        byte sideType = reader.readInt8();
        return new AbstractId2DataOracle.Entry<NetworkConnectionAndType>(id, new NetworkConnectionAndType(new NetworkConnection(localAddress, localPort, remoteAddress, remotePort, isStreamSocket), NetworkConnectionSideType.get(sideType)));
    }

    @Override
    protected AbstractId2DataOracle.Creator getCreator(OutputStreamResourceWriter writer, LongWriteRandomAccessFile index) {
        return new AbstractId2DataOracle.Creator(writer, index){
            private final Map<Long, AbstractId2DataOracle.Entry<NetworkConnectionAndType>> id2Entry;
            private final Map<Long, Boolean> streamSockets;
            {
                this.id2Entry = new HashMap<Long, AbstractId2DataOracle.Entry<NetworkConnectionAndType>>();
                this.streamSockets = new HashMap<Long, Boolean>();
            }

            @Override
            protected void handleImpl(ProfilingPacket packet) throws IOException {
                if (packet instanceof SocketAcceptEvent) {
                    SocketAcceptEvent event = (SocketAcceptEvent)packet;
                    assert (this.id2Entry.get(event.getId()) == null);
                    this.id2Entry.remove(event.getId());
                    this.writeValue(new AbstractId2DataOracle.Entry<NetworkConnectionAndType>(event.getId(), new NetworkConnectionAndType(new NetworkConnection(event.getLocalAddress(), event.getLocalPort(), event.getRemoteAddress(), event.getRemotePort(), true), NetworkConnectionSideType.SERVER)));
                    this.writeIndex(event.getId());
                } else if (packet instanceof SocketOpenEvent) {
                    SocketOpenEvent event = (SocketOpenEvent)packet;
                    assert (this.streamSockets.get(event.getId()) == null);
                    this.streamSockets.put(event.getId(), event.isStreamSocket());
                    assert (this.id2Entry.get(event.getId()) == null);
                    this.id2Entry.put(event.getId(), new AbstractId2DataOracle.Entry<NetworkConnectionAndType>(event.getId(), new NetworkConnectionAndType(new NetworkConnection(IpAddressUtil.getUnknownAddress((SocketOpenEvent)event), '\u0000', IpAddressUtil.getUnknownAddress((SocketOpenEvent)event), '\u0000', event.isStreamSocket()), NetworkConnectionSideType.UNCONNECTED)));
                    this.createDummyIndex(event.getId());
                } else if (packet instanceof SocketBindEvent) {
                    SocketBindEvent event = (SocketBindEvent)packet;
                    assert (this.id2Entry.get(event.getId()) == null || this.id2Entry.get(event.getId()).getId() == event.getId());
                    Boolean isStream = this.streamSockets.get(event.getId());
                    this.id2Entry.put(event.getId(), new AbstractId2DataOracle.Entry<NetworkConnectionAndType>(event.getId(), new NetworkConnectionAndType(new NetworkConnection(event.getLocalAddress(), event.getLocalPort(), IpAddressUtil.getUnknownAddress((SocketBindEvent)event), '\u0000', isStream != null ? isStream : true), NetworkConnectionSideType.UNCONNECTED)));
                    if (isStream == null) {
                        Trace.warn(() -> "Stream/datagram property missing for socket with file descriptor " + event.getFd() + " (id=" + event.getId() + ")");
                    }
                } else if (packet instanceof SocketConnectEvent) {
                    SocketConnectEvent event = (SocketConnectEvent)packet;
                    Boolean isStream = this.streamSockets.get(event.getId());
                    this.writeValue(new AbstractId2DataOracle.Entry<NetworkConnectionAndType>(event.getId(), new NetworkConnectionAndType(new NetworkConnection(event.getLocalAddress(), event.getLocalPort(), event.getRemoteAddress(), event.getRemotePort(), isStream != null ? isStream : true), NetworkConnectionSideType.CLIENT)));
                    assert (this.id2Entry.get(event.getId()) == null || this.id2Entry.get(event.getId()).getId() == event.getId());
                    this.id2Entry.remove(event.getId());
                    this.writeIndex(event.getId());
                    if (isStream == null) {
                        Trace.warn(() -> "Stream/datagram property missing for socket with file descriptor " + event.getFd() + " (id=" + event.getId() + ")");
                    }
                } else if (packet instanceof SocketCloseEvent) {
                    SocketCloseEvent event = (SocketCloseEvent)packet;
                    AbstractId2DataOracle.Entry<NetworkConnectionAndType> connection = this.id2Entry.remove(event.getId());
                    assert (connection == null || connection.getId() == event.getId());
                    if (connection != null) {
                        this.writeValue(connection);
                        this.writeIndex(connection.getId());
                    }
                    this.streamSockets.remove(event.getId());
                }
            }

            @Override
            protected void prepareForFinish() {
            }

            @Override
            protected void finishImpl(long id) throws IOException {
                AbstractId2DataOracle.Entry<NetworkConnectionAndType> entry = this.id2Entry.get(id);
                this.writeValue(entry);
                this.writeIndex(id);
            }
        };
    }

    @Override
    protected AbstractId2DataOracle.AdditionalPacketReader getAdditionalReader(final ProfilingReader reader) {
        return new AbstractId2DataOracle.AdditionalPacketReader(){
            private Object[] events;
            private int index;
            {
                this.events = reader.getSocketManager().getEvents();
                this.index = 0;
            }

            @Override
            public ProfilingPacket next() throws IOException {
                if (this.index >= this.events.length) {
                    return null;
                }
                return (ProfilingPacket)this.events[this.index++];
            }
        };
    }

    @Override
    protected String[] getMessages() {
        return new String[]{I18n._s((String)"Creating data cache ordered by identifiers ... (<%> %)"), I18n._s((String)"Reading data cache ordered by identifiers ... (<%> %)"), I18n._s((String)"Writing data cache ordered by identifiers ... (<%> %)")};
    }
}

