/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.net.command.NetworkTraceConfiguration;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkValueIterator;
import com.sap.jvm.profiling.snapshot.net.NetworkSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class NetworkSnapshotImpl
extends SnapshotImpl
implements NetworkSnapshot {
    private ResourceName resourceName;
    private long nrOfReadBytes;
    private long nrOfWrittenBytes;
    private long readDuration;
    private long writeDuration;
    private final NetworkTraceConfiguration config;

    public static NetworkSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long nrOfReadBytes = reader.readInt64();
        long nrOfWrittenBytes = reader.readInt64();
        long readDuration = reader.readInt64();
        long writeDuration = reader.readInt64();
        NetworkTraceConfiguration config = NetworkSnapshotImpl.readNetTraceConfig(reader);
        NetworkSnapshotImpl snapshot = new NetworkSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, config, nrOfReadBytes, nrOfWrittenBytes, readDuration, writeDuration, startTimestamp, endTimestamp, isVirtual, null);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public NetworkSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, NetworkTraceConfiguration config, long nrOfReadBytes, long nrOfWrittenBytes, long readDuration, long writeDuration, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, NetworkSnapshot parent) {
        super(SnapshotType.NETWORK_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.config = config;
        this.nrOfReadBytes = nrOfReadBytes;
        this.nrOfWrittenBytes = nrOfWrittenBytes;
        this.readDuration = readDuration;
        this.writeDuration = writeDuration;
        this.resourceName = resourceName;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        if (this.nrOfReadBytes >= 0L && this.nrOfWrittenBytes > 0L && this.readDuration >= 0L && this.writeDuration >= 0L) {
            return;
        }
        this.nrOfReadBytes = 0L;
        this.nrOfWrittenBytes = 0L;
        this.readDuration = 0L;
        this.writeDuration = 0L;
        NetworkValueIterator it = this.getNetworkEventIterator(reporter, I18n._s((String)"Analyzing the network I/O events ... (<%> %)"));
        try {
            while (it.next()) {
                this.nrOfReadBytes += (long)it.getNrOfReadBytes();
                this.readDuration += it.getReadTime();
                this.nrOfWrittenBytes += (long)it.getNrOfWrittenBytes();
                this.writeDuration += it.getWriteTime();
            }
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Failed to analyze the I/O events");
        }
    }

    @Override
    public long getNrOfTransferredBytes() {
        return this.nrOfReadBytes + this.nrOfWrittenBytes;
    }

    @Override
    public long getNrOfWrittenBytes() {
        return this.nrOfWrittenBytes;
    }

    @Override
    public long getNrOfReadBytes() {
        return this.nrOfReadBytes;
    }

    @Override
    public long getDuration() {
        return this.readDuration + this.writeDuration;
    }

    @Override
    public long getReadDuration() {
        return this.readDuration;
    }

    @Override
    public long getWriteDuration() {
        return this.writeDuration;
    }

    @Override
    public NetworkValueIterator getNetworkEventIterator(ProgressReporter progressReporter, String message) throws OperationCanceledException {
        return new NetworkValueIterator(this, this.asResourceName(), progressReporter, message);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfReadBytes);
        writer.writeInt64(this.nrOfWrittenBytes);
        writer.writeInt64(this.readDuration);
        writer.writeInt64(this.writeDuration);
        this.writeNetTraceConfig((ResourceWriter)writer);
    }

    @Override
    public NetworkTraceConfiguration getTraceConfiguration() {
        return this.config;
    }

    private void writeNetTraceConfig(ResourceWriter writer) throws IOException {
        writer.writeNewThreadFilter(this.config.getThreadFilter());
        writer.writeBoolean(this.config.isResolveAllHosts());
    }

    private static NetworkTraceConfiguration readNetTraceConfig(ResourceReader reader) throws IOException {
        ThreadFilter threadFilter = reader.readNewThreadFilter();
        boolean resolveAllHosts = reader.hasNext() ? reader.readBoolean() : false;
        NetworkTraceConfiguration retValue = new NetworkTraceConfiguration();
        retValue.setThreadFilter(threadFilter);
        retValue.setResolveAllHosts(resolveAllHosts);
        return retValue;
    }
}

