/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkValueIteratorBase;
import com.sap.jvm.profiling.snapshot.impl.net.StackStatisticImpl;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import com.sap.jvm.profiling.snapshot.net.NetworkSnapshot;
import com.sap.jvm.profiling.snapshot.net.StackIterator;
import java.io.IOException;

public final class NetworkValueIterator
extends NetworkValueIteratorBase<NetworkOperations> {
    public NetworkValueIterator(NetworkSnapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(snapshot, name, reporter, message, false);
    }

    public NetworkValueIterator(ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(name, reporter, message, false);
    }

    public NetworkValueIterator(ResourceName name, ProgressReporter reporter, String message, boolean useOracle) throws OperationCanceledException {
        super(name, reporter, message, useOracle);
    }

    public NetworkValueIterator(StackIterator it, ResourceName name, ProgressReporter reporter) {
        super(it, name, reporter);
    }

    public static NetworkValueIterator getEventIterator(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        return NetworkValueIterator.getIterators(name, 1, reporter, message, true)[0];
    }

    public static NetworkValueIterator[] getIterators(ResourceName name, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        return NetworkValueIterator.getIterators(name, name.getSession().getNrOfThreads(), reporter, message, usesEvents);
    }

    public static NetworkValueIterator[] getIterators(ResourceName name, int nrOfIterators, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        ProfilingSession session = name.getSession();
        NetworkSnapshot snapshot = (NetworkSnapshot)SnapshotResourceManagerFactory.get(session).getSnapshot(name);
        if (usesEvents || NetworkValueIterator.needsEventIteration(name)) {
            return new NetworkValueIterator[]{new NetworkValueIterator(snapshot, name, reporter, message)};
        }
        ResourceName sName = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateStackStatistic());
        StackStatisticImpl statistic = (StackStatisticImpl)session.getResourceManager().get(sName, reporter);
        if (statistic == null) {
            throw new OperationCanceledException();
        }
        StackStatisticImpl.StackIteratorImpl[] baseIterators = statistic.getIterators(nrOfIterators);
        NetworkValueIterator[] result = new NetworkValueIterator[baseIterators.length];
        ProgressReporter[] dummyReporters = reporter.getChildren(nrOfIterators - 1);
        result[0] = new NetworkValueIterator(baseIterators[0], name, reporter);
        for (int i = 1; i < result.length; ++i) {
            result[i] = new NetworkValueIterator(baseIterators[i], name, dummyReporters[i - 1]);
        }
        reporter.setWork(message, result[0].it.getMaxProgress());
        return result;
    }

    @Override
    public NetworkOperations getEmptyValue() {
        return NetworkOperations.EMPTY;
    }

    @Override
    public NetworkOperations getValue() {
        return this.getNetworkOperationsValue();
    }
}

