/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.type.HostNameManager;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.NetworkServiceNameManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.net.event.DirectedSocketReadEvent;
import com.sap.jvm.profiling.net.event.DirectedSocketWriteEvent;
import com.sap.jvm.profiling.net.event.IpAddressUtil;
import com.sap.jvm.profiling.net.event.NetworkEventHandler;
import com.sap.jvm.profiling.net.event.SocketAcceptEvent;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.net.event.SocketCloseEvent;
import com.sap.jvm.profiling.net.event.SocketConnectEvent;
import com.sap.jvm.profiling.net.event.SocketConnectFailureEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.net.event.SocketReadEvent;
import com.sap.jvm.profiling.net.event.SocketWriteEvent;
import com.sap.jvm.profiling.net.response.DisableNetworkTraceResponse;
import com.sap.jvm.profiling.net.response.EnableNetworkTraceResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.filter.SocketFilter;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkConnectionAndType;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkConnectionOracle;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkTraceNameExtractor;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.AbstractId2DataOracle;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;
import com.sap.jvm.profiling.snapshot.net.NetworkDetails;
import com.sap.jvm.profiling.snapshot.net.NetworkEventIterator;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import com.sap.jvm.profiling.snapshot.net.NetworkLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkOperations;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndDetails;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import com.sap.jvm.profiling.snapshot.net.NetworkSnapshot;
import com.sap.jvm.profiling.snapshot.net.StackIterator;
import com.sap.jvm.profiling.snapshot.resource.SocketId;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class NetworkValueIteratorBase<V extends Value<V>>
extends AbstractValueIterator<V>
implements NetworkEventHandler,
NetworkEventIterator {
    private final ProfilingReader reader;
    private final ProgressReporter reporter;
    private SocketOpenEvent currentSocketOpenEvent;
    private SocketBindEvent currentSocketBindEvent;
    private SocketConnectEvent currentSocketConnectEvent;
    private SocketReadEvent currentSocketReadEvent;
    private SocketWriteEvent currentSocketWriteEvent;
    private SocketCloseEvent currentSocketCloseEvent;
    private SocketId currentSocketId;
    private final Map<Long, Long> id2Index;
    private long nextIndex;
    private final List<IpAddress> fd2LocalAddress;
    private final List<Character> fd2LocalPort;
    private final List<IpAddress> fd2RemoteAddress;
    private final List<Character> fd2RemotePort;
    private final List<Long> fd2LastReadTimestamp;
    private final List<Long> fd2LastWriteTimestamp;
    private final List<Boolean> fd2DatagramSocket;
    private long currentReadWriteLatency;
    private long currentWriteReadLatency;
    private IpAddress currentDirectedRemoteAddress;
    private char currentDirectedRemotePort;
    public final StackIterator it;
    private SocketFilter socketFilter;
    private boolean useOracle = false;
    private AbstractId2DataOracle.DataReader<NetworkConnectionAndType> connectionReader = null;
    private AbstractId2DataOracle.Entry<NetworkConnectionAndType> cachedConnection = null;
    public final IpAddress unknownAddress = IpAddressUtil.getDefaultUnknownAddress();
    private final String unknownRemoteAddress = I18n._s((String)"<unconnected>");
    private Object[] initiallyOpenedSockets;
    private int initiallyOpenedSocketsIndex = -1;
    private int initiallyOpenedSocketsCount = 0;

    public NetworkValueIteratorBase(NetworkSnapshot snapshot, ResourceName name, ProgressReporter reporter, String message, boolean useOracle) throws OperationCanceledException {
        super(name, snapshot, reporter);
        this.reader = this.getEventReader();
        this.socketFilter = NetworkTraceNameExtractor.getSocketFilter(name);
        this.useOracle = useOracle;
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.fd2LocalAddress = new ArrayList<IpAddress>(Arrays.asList(new IpAddress[32768]));
        this.fd2LocalPort = new ArrayList<Character>(Arrays.asList(new Character[32768]));
        this.fd2RemoteAddress = new ArrayList<IpAddress>(Arrays.asList(new IpAddress[32768]));
        this.fd2RemotePort = new ArrayList<Character>(Arrays.asList(new Character[32768]));
        this.fd2LastReadTimestamp = new ArrayList<Long>(Arrays.asList(new Long[32768]));
        this.fd2LastWriteTimestamp = new ArrayList<Long>(Arrays.asList(new Long[32768]));
        this.fd2DatagramSocket = new ArrayList<Boolean>(Arrays.asList(new Boolean[32768]));
        this.id2Index = new HashMap<Long, Long>();
        this.nextIndex = 0L;
        this.reader.registerNetworkEventHandler((NetworkEventHandler)this);
        this.it = null;
    }

    protected NetworkValueIteratorBase(StackIterator it, ResourceName name, ProgressReporter reporter) {
        super(name, null);
        assert (!this.usesEvents());
        this.reporter = reporter;
        this.it = it;
        this.fd2LocalAddress = null;
        this.fd2LocalPort = null;
        this.fd2RemoteAddress = null;
        this.fd2RemotePort = null;
        this.fd2LastReadTimestamp = null;
        this.fd2LastWriteTimestamp = null;
        this.fd2DatagramSocket = null;
        this.id2Index = null;
        this.reader = null;
    }

    public NetworkValueIteratorBase(ResourceName name, ProgressReporter reporter, String message, boolean useOracle) throws OperationCanceledException {
        this((NetworkSnapshotImpl)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name), name, reporter, message, useOracle);
    }

    @Override
    public int getStackIndex() {
        if (this.it != null) {
            return this.it.getStackIndex();
        }
        if (this.currentSocketReadEvent != null) {
            return this.currentSocketReadEvent.getStackTraceIndex();
        }
        if (this.currentSocketWriteEvent != null) {
            return this.currentSocketWriteEvent.getStackTraceIndex();
        }
        if (this.currentSocketOpenEvent != null) {
            return this.currentSocketOpenEvent.getStackTraceIndex();
        }
        if (this.currentSocketBindEvent != null) {
            return this.currentSocketBindEvent.getStackTraceIndex();
        }
        if (this.currentSocketConnectEvent != null) {
            return this.currentSocketConnectEvent.getStackTraceIndex();
        }
        if (this.currentSocketCloseEvent != null) {
            return this.currentSocketCloseEvent.getStackTraceIndex();
        }
        return 0;
    }

    @Override
    public char getThreadIndex() {
        if (this.currentSocketReadEvent != null) {
            return this.currentSocketReadEvent.getThreadIndex();
        }
        if (this.currentSocketWriteEvent != null) {
            return this.currentSocketWriteEvent.getThreadIndex();
        }
        if (this.currentSocketOpenEvent != null) {
            return this.currentSocketOpenEvent.getThreadIndex();
        }
        if (this.currentSocketBindEvent != null) {
            return this.currentSocketBindEvent.getThreadIndex();
        }
        if (this.currentSocketConnectEvent != null) {
            return this.currentSocketConnectEvent.getThreadIndex();
        }
        if (this.currentSocketCloseEvent != null) {
            return this.currentSocketCloseEvent.getThreadIndex();
        }
        return '\u0000';
    }

    public long getTimestamp() {
        if (this.currentSocketReadEvent != null) {
            return this.currentSocketReadEvent.getTimeStamp();
        }
        if (this.currentSocketWriteEvent != null) {
            return this.currentSocketWriteEvent.getTimeStamp();
        }
        if (this.currentSocketOpenEvent != null) {
            return this.currentSocketOpenEvent.getTimeStamp();
        }
        if (this.currentSocketBindEvent != null) {
            return this.currentSocketBindEvent.getTimeStamp();
        }
        if (this.currentSocketConnectEvent != null) {
            return this.currentSocketConnectEvent.getTimeStamp();
        }
        if (this.currentSocketCloseEvent != null) {
            return this.currentSocketCloseEvent.getTimeStamp();
        }
        return -1L;
    }

    public NetworkOperations getNetworkOperationsValue() {
        if (this.it != null) {
            return this.it.getNetworkOperations();
        }
        return new NetworkOperations(this.currentSocketOpenEvent != null ? (long)(this.isSynthetic(this.currentSocketOpenEvent) ? 0 : 1) : 0L, this.currentSocketCloseEvent != null ? 1L : 0L, this.currentSocketReadEvent != null ? (long)this.currentSocketReadEvent.getNrOfReadBytes() : 0L, this.currentSocketWriteEvent != null ? (long)this.currentSocketWriteEvent.getNrOfWrittenBytes() : 0L, this.currentSocketReadEvent != null ? this.currentSocketReadEvent.getDuration() : 0L, this.currentSocketWriteEvent != null ? this.currentSocketWriteEvent.getDuration() : 0L, this.currentSocketReadEvent != null ? 1L : 0L, this.currentSocketWriteEvent != null ? 1L : 0L);
    }

    public NetworkDetails getNetworkDetails() {
        long fd = this.getFd();
        return new NetworkDetails(fd, this.currentSocketOpenEvent != null ? this.currentSocketOpenEvent.getTimeStamp() : 0L, this.currentSocketOpenEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentSocketOpenEvent != null ? this.getThreadInfo().getNameUTF() : null, this.currentSocketCloseEvent != null ? this.currentSocketCloseEvent.getTimeStamp() : 0L, this.currentSocketCloseEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentSocketCloseEvent != null ? this.getThreadInfo().getNameUTF() : null);
    }

    public NetworkOperationsAndDetails getNetworkOperationsAndDetails() {
        long fd = this.getFd();
        return new NetworkOperationsAndDetails(fd, this.currentSocketOpenEvent != null ? this.currentSocketOpenEvent.getTimeStamp() : 0L, this.currentSocketOpenEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentSocketOpenEvent != null ? this.getThreadInfo().getNameUTF() : null, this.currentSocketCloseEvent != null ? this.currentSocketCloseEvent.getTimeStamp() : 0L, this.currentSocketCloseEvent != null ? this.getThreadInfo().getThreadId() : 0L, this.currentSocketCloseEvent != null ? this.getThreadInfo().getNameUTF() : null, this.currentSocketReadEvent != null ? (long)this.currentSocketReadEvent.getNrOfReadBytes() : 0L, this.currentSocketWriteEvent != null ? (long)this.currentSocketWriteEvent.getNrOfWrittenBytes() : 0L, this.currentSocketReadEvent != null ? this.currentSocketReadEvent.getDuration() : 0L, this.currentSocketWriteEvent != null ? this.currentSocketWriteEvent.getDuration() : 0L, this.currentSocketReadEvent != null ? 1L : 0L, this.currentSocketWriteEvent != null ? 1L : 0L, this.getNetworkLatencies());
    }

    public NetworkOperationsAndLatencies getNetworkOperationsAndLatencies() {
        assert (this.it == null);
        return new NetworkOperationsAndLatencies(this.getNetworkOperationsValue(), this.getNetworkLatencies());
    }

    public NetworkLatencies getNetworkLatencies() {
        assert (this.it == null);
        return new NetworkLatencies(this.currentReadWriteLatency >= 0L ? this.currentReadWriteLatency : Long.MAX_VALUE, this.currentReadWriteLatency >= 0L ? this.currentReadWriteLatency : Long.MIN_VALUE, this.currentReadWriteLatency >= 0L ? this.currentReadWriteLatency : 0L, this.currentReadWriteLatency >= 0L ? 1L : 0L, this.currentWriteReadLatency >= 0L ? this.currentWriteReadLatency : Long.MAX_VALUE, this.currentWriteReadLatency >= 0L ? this.currentWriteReadLatency : Long.MIN_VALUE, this.currentWriteReadLatency >= 0L ? this.currentWriteReadLatency : 0L, this.currentWriteReadLatency >= 0L ? 1L : 0L, this.getSocketType() == NetworkConnectionSideType.SERVER);
    }

    public NetworkConnection getNetworkConnection() throws IOException {
        return new NetworkConnection(this.getLocalAddress(), this.getLocalPort(), this.getRemoteAddress(), this.getRemotePort(), !this.isDatagramSocket());
    }

    public NetworkService getNetworkService() throws IOException {
        return new NetworkService(this.getServiceName(), this.getServicePort(), this.getSocketType(), !this.isDatagramSocket());
    }

    public NetworkHost getNetworkHost() throws IOException {
        IpAddress remoteAddress;
        HostNameManager hostnameManager = this.getSession().getHostNameManager();
        UTF8String hostname = hostnameManager.getHostName(remoteAddress = this.getRemoteAddress());
        String name = hostname != null ? hostname.toString() : (IpAddressUtil.isUnknown((IpAddress)remoteAddress) ? this.unknownRemoteAddress : remoteAddress.getAddress());
        return new NetworkHost(name, remoteAddress);
    }

    public SocketId getSocketId() {
        return this.currentSocketId;
    }

    @Override
    public int getFd() {
        if (this.currentSocketOpenEvent != null) {
            return this.currentSocketOpenEvent.getFd();
        }
        if (this.currentSocketBindEvent != null) {
            return this.currentSocketBindEvent.getFd();
        }
        if (this.currentSocketConnectEvent != null) {
            return this.currentSocketConnectEvent.getFd();
        }
        if (this.currentSocketReadEvent != null) {
            return this.currentSocketReadEvent.getFd();
        }
        if (this.currentSocketWriteEvent != null) {
            return this.currentSocketWriteEvent.getFd();
        }
        if (this.currentSocketCloseEvent != null) {
            return this.currentSocketCloseEvent.getFd();
        }
        return -1;
    }

    private long getId() {
        if (this.currentSocketOpenEvent != null) {
            return this.currentSocketOpenEvent.getId();
        }
        if (this.currentSocketBindEvent != null) {
            return this.currentSocketBindEvent.getId();
        }
        if (this.currentSocketConnectEvent != null) {
            return this.currentSocketConnectEvent.getId();
        }
        if (this.currentSocketReadEvent != null) {
            return this.currentSocketReadEvent.getId();
        }
        if (this.currentSocketWriteEvent != null) {
            return this.currentSocketWriteEvent.getId();
        }
        if (this.currentSocketCloseEvent != null) {
            return this.currentSocketCloseEvent.getId();
        }
        return -1L;
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        if (this.it.next()) {
            if (!this.reporter.report(this.it.getProgress())) {
                throw new OperationCanceledException();
            }
            return true;
        }
        return false;
    }

    @Override
    public int nextOrReadRaw() throws IOException {
        if ((this.socketFilter != null || this.useOracle) && this.connectionReader == null) {
            this.connectionReader = NetworkConnectionOracle.get(this.getResourceName(), this.reporter).getReader(this.getSession());
        }
        this.currentSocketOpenEvent = null;
        this.currentSocketBindEvent = null;
        this.currentSocketConnectEvent = null;
        this.currentSocketReadEvent = null;
        this.currentSocketWriteEvent = null;
        this.currentSocketCloseEvent = null;
        this.currentDirectedRemoteAddress = null;
        this.currentDirectedRemotePort = '\u0000';
        this.currentReadWriteLatency = -1L;
        this.currentWriteReadLatency = -1L;
        try {
            if (this.readNextInitialEvent() || this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.currentSocketOpenEvent == null && this.currentSocketReadEvent == null && this.currentSocketCloseEvent == null && this.currentSocketWriteEvent == null && this.currentSocketBindEvent == null && this.currentSocketConnectEvent == null) {
                    return 1;
                }
                if (!this.appliesSocketFilter(this.getFd(), this.getId())) {
                    return 1;
                }
                this.updateSocketId();
                this.updateLatencies();
                return 0;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    @Override
    protected ResourceName getDependentForIt() {
        return null;
    }

    @Override
    public SocketOpenEvent getSocketOpenEvent() {
        return this.currentSocketOpenEvent;
    }

    @Override
    public SocketBindEvent getSocketBindEvent() {
        return this.currentSocketBindEvent;
    }

    @Override
    public SocketConnectEvent getSocketConnectEvent() {
        return this.currentSocketConnectEvent;
    }

    @Override
    public SocketReadEvent getSocketReadEvent() {
        return this.currentSocketReadEvent;
    }

    @Override
    public SocketWriteEvent getSocketWriteEvent() {
        return this.currentSocketWriteEvent;
    }

    @Override
    public SocketCloseEvent getSocketCloseEvent() {
        return this.currentSocketCloseEvent;
    }

    public void handle(EnableNetworkTraceResponse response) {
    }

    public void handle(DisableNetworkTraceResponse response) {
    }

    public void handle(SocketOpenEvent event) {
        this.currentSocketOpenEvent = event;
        this.removeAddress(event.getFd(), this.fd2LocalAddress, this.fd2LocalPort);
        this.removeAddress(event.getFd(), this.fd2RemoteAddress, this.fd2RemotePort);
        this.removeTimestamp(event.getFd(), this.fd2LastReadTimestamp);
        this.removeTimestamp(event.getFd(), this.fd2LastWriteTimestamp);
        this.setSocketFlag(event.getFd(), this.fd2DatagramSocket, event.isDatagramSocket());
    }

    public void handle(SocketBindEvent event) {
        this.currentSocketBindEvent = event;
        this.addAddress(event.getFd(), this.fd2LocalAddress, event.getLocalAddress(), this.fd2LocalPort, event.getLocalPort());
    }

    public void handle(SocketConnectEvent event) {
        this.currentSocketConnectEvent = event;
        this.addAddress(event.getFd(), this.fd2LocalAddress, event.getLocalAddress(), this.fd2LocalPort, event.getLocalPort());
        this.addAddress(event.getFd(), this.fd2RemoteAddress, event.getRemoteAddress(), this.fd2RemotePort, event.getRemotePort());
    }

    public void handle(SocketConnectFailureEvent event) {
    }

    public void handle(SocketAcceptEvent event) {
        this.currentSocketOpenEvent = event;
        this.addAddress(event.getFd(), this.fd2LocalAddress, event.getLocalAddress(), this.fd2LocalPort, event.getLocalPort());
        this.addAddress(event.getFd(), this.fd2RemoteAddress, event.getRemoteAddress(), this.fd2RemotePort, event.getRemotePort());
        this.removeTimestamp(event.getFd(), this.fd2LastReadTimestamp);
        this.removeTimestamp(event.getFd(), this.fd2LastWriteTimestamp);
        this.setSocketFlag(event.getFd(), this.fd2DatagramSocket, false);
    }

    public void handle(SocketReadEvent event) {
        this.currentSocketReadEvent = event;
        this.addTimestamp(event.getFd(), this.fd2LastReadTimestamp, event.getTimeStamp() + event.getDuration() / 1000000L);
    }

    public void handle(DirectedSocketReadEvent event) {
        this.currentSocketReadEvent = event;
        this.currentDirectedRemoteAddress = event.getRemoteAddress();
        this.currentDirectedRemotePort = event.getRemotePort();
        this.addTimestamp(event.getFd(), this.fd2LastReadTimestamp, event.getTimeStamp() + event.getDuration() / 1000000L);
    }

    public void handle(SocketWriteEvent event) {
        this.currentSocketWriteEvent = event;
        this.addTimestamp(event.getFd(), this.fd2LastWriteTimestamp, event.getTimeStamp() + event.getDuration() / 1000000L);
    }

    public void handle(DirectedSocketWriteEvent event) {
        this.currentSocketWriteEvent = event;
        this.currentDirectedRemoteAddress = event.getRemoteAddress();
        this.currentDirectedRemotePort = event.getRemotePort();
        this.addTimestamp(event.getFd(), this.fd2LastWriteTimestamp, event.getTimeStamp() + event.getDuration() / 1000000L);
    }

    public void handle(SocketCloseEvent event) {
        this.currentSocketCloseEvent = event;
        this.removeAddress(event.getFd(), this.fd2LocalAddress, this.fd2LocalPort);
        this.removeAddress(event.getFd(), this.fd2RemoteAddress, this.fd2RemotePort);
        this.removeTimestamp(event.getFd(), this.fd2LastReadTimestamp);
        this.removeTimestamp(event.getFd(), this.fd2LastWriteTimestamp);
        if (this.connectionReader != null) {
            try {
                this.cachedConnection = new AbstractId2DataOracle.Entry<NetworkConnectionAndType>(event.getId(), this.connectionReader.getData(event.getId()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.connectionReader.finished(event.getId());
        }
    }

    @Override
    public int getOpenCount() {
        return this.currentSocketOpenEvent != null ? (this.isSynthetic(this.currentSocketOpenEvent) ? 0 : 1) : 0;
    }

    @Override
    public int getCloseCount() {
        return this.currentSocketCloseEvent != null ? 1 : 0;
    }

    @Override
    public int getNrOfReadOperations() {
        return this.currentSocketReadEvent != null ? 1 : 0;
    }

    @Override
    public int getNrOfWriteOperations() {
        return this.currentSocketWriteEvent != null ? 1 : 0;
    }

    @Override
    public int getNrOfReadBytes() {
        return this.currentSocketReadEvent != null ? this.currentSocketReadEvent.getNrOfReadBytes() : 0;
    }

    @Override
    public long getReadTime() {
        return this.currentSocketReadEvent != null ? this.currentSocketReadEvent.getDuration() : 0L;
    }

    @Override
    public long getWriteTime() {
        return this.currentSocketWriteEvent != null ? this.currentSocketWriteEvent.getDuration() : 0L;
    }

    @Override
    public int getNrOfWrittenBytes() {
        return this.currentSocketWriteEvent != null ? this.currentSocketWriteEvent.getNrOfWrittenBytes() : 0;
    }

    private NetworkConnectionAndType getConnection(long id) throws IOException {
        if (this.cachedConnection != null && this.cachedConnection.getId() == id) {
            return this.cachedConnection.getValue();
        }
        this.cachedConnection = new AbstractId2DataOracle.Entry<NetworkConnectionAndType>(id, this.connectionReader.getData(id));
        return this.cachedConnection.getValue();
    }

    private IpAddress getLocalAddress(int fd, long id) throws IOException {
        if (this.connectionReader != null) {
            return this.getConnection(id).getConnection().getLocalAddress();
        }
        return this.getAddress(fd, this.fd2LocalAddress, this.unknownAddress);
    }

    @Override
    public IpAddress getLocalAddress() throws IOException {
        return this.getLocalAddress(this.getFd(), this.getId());
    }

    private char getLocalPort(int fd, long id) throws IOException {
        if (this.connectionReader != null) {
            return this.getConnection(id).getConnection().getLocalPort();
        }
        return this.getPort(fd, this.fd2LocalPort);
    }

    @Override
    public char getLocalPort() throws IOException {
        return this.getLocalPort(this.getFd(), this.getId());
    }

    private IpAddress getRemoteAddress(int fd, long id) throws IOException {
        if (this.currentDirectedRemoteAddress != null) {
            return this.currentDirectedRemoteAddress;
        }
        if (this.connectionReader != null) {
            return this.getConnection(id).getConnection().getRemoteAddress();
        }
        return this.getAddress(fd, this.fd2RemoteAddress, this.unknownAddress);
    }

    @Override
    public IpAddress getRemoteAddress() throws IOException {
        return this.getRemoteAddress(this.getFd(), this.getId());
    }

    private char getRemotePort(int fd, long id) throws IOException {
        if (this.currentDirectedRemotePort != '\u0000') {
            return this.currentDirectedRemotePort;
        }
        if (this.connectionReader != null) {
            return this.getConnection(id).getConnection().getRemotePort();
        }
        return this.getPort(fd, this.fd2RemotePort);
    }

    @Override
    public char getRemotePort() throws IOException {
        return this.getRemotePort(this.getFd(), this.getId());
    }

    @Override
    public NetworkConnectionSideType getSocketType() {
        if (this.connectionReader != null) {
            try {
                return this.getConnection(this.getId()).getSide();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Network Oracle missing");
    }

    @Override
    public boolean isDatagramSocket() {
        return this.isSocketFlag(this.getFd(), this.fd2DatagramSocket);
    }

    private boolean appliesSocketFilter(int fd, long id) throws IOException {
        return this.socketFilter == null || this.socketFilter.applies(this.getLocalAddress(fd, id), this.getLocalPort(fd, id), this.getRemoteAddress(fd, id), this.getRemotePort(fd, id), !this.isDatagramSocket(), id, this.getSocketType(), this.getServiceName());
    }

    private void addAddress(int index, List<IpAddress> addresses, IpAddress address, List<Character> ports, char port) {
        while (index >= addresses.size()) {
            addresses.add(null);
        }
        while (index >= ports.size()) {
            ports.add(Character.valueOf('\u0000'));
        }
        addresses.set(index, address);
        ports.set(index, Character.valueOf(port));
    }

    private void removeAddress(int index, List<IpAddress> addresses, List<Character> ports) {
        if (index < 0 || index >= addresses.size()) {
            return;
        }
        assert (index < ports.size());
        addresses.set(index, null);
        ports.set(index, Character.valueOf('\u0000'));
    }

    private IpAddress getAddress(int index, List<IpAddress> addresses, IpAddress defaultValue) {
        if (index < 0 || index >= addresses.size()) {
            return defaultValue;
        }
        IpAddress result = addresses.get(index);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private char getPort(int index, List<Character> ports) {
        if (index < 0 || index >= ports.size()) {
            return '\u0000';
        }
        Character result = ports.get(index);
        if (result == null) {
            result = Character.valueOf('\u0000');
        }
        return result.charValue();
    }

    private void addTimestamp(int index, List<Long> timestamps, long ts) {
        while (index >= timestamps.size()) {
            timestamps.add(null);
        }
        timestamps.set(index, ts);
    }

    private void removeTimestamp(int index, List<Long> timestamps) {
        if (index < 0 || index >= timestamps.size()) {
            return;
        }
        timestamps.set(index, null);
    }

    private long getTimestamp(int index, List<Long> timestamps, long defaultValue) {
        if (index < 0 || index >= timestamps.size()) {
            return defaultValue;
        }
        Long result = timestamps.get(index);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private void updateSocketId() {
        long id = this.getId();
        Long indexObj = this.id2Index.get(id);
        if (indexObj == null) {
            indexObj = this.nextIndex++;
            this.id2Index.put(id, indexObj);
        }
        long index = indexObj;
        this.currentSocketId = new SocketId(id, index);
    }

    private void updateLatencies() {
        if (this.currentSocketReadEvent != null) {
            long writeTs = this.getTimestamp(this.currentSocketReadEvent.getFd(), this.fd2LastWriteTimestamp, Long.MIN_VALUE);
            if (writeTs != Long.MIN_VALUE) {
                this.currentWriteReadLatency = Math.max(0L, this.currentSocketReadEvent.getTimeStamp() - writeTs);
            }
            this.removeTimestamp(this.currentSocketReadEvent.getFd(), this.fd2LastWriteTimestamp);
        }
        if (this.currentSocketWriteEvent != null) {
            long readTs = this.getTimestamp(this.currentSocketWriteEvent.getFd(), this.fd2LastReadTimestamp, Long.MIN_VALUE);
            if (readTs != Long.MIN_VALUE) {
                this.currentReadWriteLatency = Math.max(0L, this.currentSocketWriteEvent.getTimeStamp() - readTs);
            }
            this.removeTimestamp(this.currentSocketWriteEvent.getFd(), this.fd2LastReadTimestamp);
        }
    }

    private boolean isSocketFlag(int index, List<Boolean> list) {
        if (index < 0 || index >= list.size()) {
            return false;
        }
        return list.get(index) != null;
    }

    private void setSocketFlag(int index, List<Boolean> list, boolean value) {
        while (index >= list.size()) {
            list.add(null);
        }
        list.set(index, value ? Boolean.TRUE : null);
    }

    private char getServicePort() throws IOException {
        if (this.getSocketType() != NetworkConnectionSideType.CLIENT) {
            return this.getLocalPort();
        }
        return this.getRemotePort();
    }

    private String getServiceName() throws IOException {
        NetworkServiceNameManager serviceManager = this.getSession().getNetworkServiceNameManager();
        String name = this.isDatagramSocket() ? serviceManager.getUdpServiceName(this.getServicePort()) : serviceManager.getTcpServiceName(this.getServicePort());
        if (name == null) {
            name = I18n._s((String)"<unknown>");
        }
        return name;
    }

    public int getNrOfSyntheticOpenEvents() {
        return this.initiallyOpenedSocketsCount;
    }

    private boolean readNextInitialEvent() {
        Object event;
        if (this.initiallyOpenedSocketsIndex < 0) {
            assert (this.initiallyOpenedSockets == null);
            this.initiallyOpenedSockets = this.reader.getSocketManager().getEvents();
            this.initiallyOpenedSocketsIndex = 0;
        }
        assert (this.initiallyOpenedSocketsIndex >= 0);
        if (this.initiallyOpenedSockets == null) {
            return false;
        }
        if (this.initiallyOpenedSocketsIndex >= this.initiallyOpenedSockets.length) {
            this.initiallyOpenedSockets = null;
            return false;
        }
        if ((event = this.initiallyOpenedSockets[this.initiallyOpenedSocketsIndex++]) instanceof SocketAcceptEvent) {
            ++this.initiallyOpenedSocketsCount;
            this.handle((SocketAcceptEvent)event);
        } else if (event instanceof SocketOpenEvent) {
            ++this.initiallyOpenedSocketsCount;
            this.handle((SocketOpenEvent)event);
        } else if (event instanceof SocketBindEvent) {
            this.handle((SocketBindEvent)event);
        } else if (event instanceof SocketConnectEvent) {
            this.handle((SocketConnectEvent)event);
        } else assert (false);
        return true;
    }

    private boolean isSynthetic(SocketOpenEvent event) {
        return this.initiallyOpenedSockets != null || event.getThreadIndex() == '\u0000' && event.getStackTraceIndex() == 0;
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }
}

