/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.net.event.SocketCloseEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.FilterBySocketId;
import com.sap.jvm.profiling.snapshot.filter.SocketFilter;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkValueIterator;
import com.sap.jvm.profiling.snapshot.net.OpenSocketFilter;
import java.io.IOException;
import java.util.HashMap;

public class OpenSocketFilterImpl
extends AbstractResource
implements OpenSocketFilter {
    private static final int VERSION = 0;
    private FilterBySocketId filterElement;

    public OpenSocketFilterImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        reader.readVersion(0, 0);
        this.filterElement = new FilterBySocketId(reader);
    }

    private OpenSocketFilterImpl(FilterBySocketId filterElement, ResourceName name) {
        super(name);
        this.filterElement = filterElement;
    }

    public static OpenSocketFilterImpl create(ResourceName name, ProgressReporter reporter) throws IOException, OperationCanceledException {
        NetworkValueIterator it = new NetworkValueIterator(name, reporter, I18n._s((String)"Searching for open sockets ... (<%> %)"));
        HashMap<Long, SocketOpenEvent> openSockets = new HashMap<Long, SocketOpenEvent>();
        while (it.next()) {
            SocketCloseEvent socketCloseEvent;
            SocketOpenEvent socketOpenEvent = it.getSocketOpenEvent();
            if (socketOpenEvent != null) {
                openSockets.put(socketOpenEvent.getId(), socketOpenEvent);
            }
            if ((socketCloseEvent = it.getSocketCloseEvent()) == null) continue;
            openSockets.remove(socketCloseEvent.getId());
        }
        long[] socketIds = new long[openSockets.size()];
        long[] fds = new long[openSockets.size()];
        long[] contIndex = new long[openSockets.size()];
        int i = 0;
        for (SocketOpenEvent openEvent : openSockets.values()) {
            socketIds[i] = openEvent.getId();
            fds[i] = openEvent.getFd();
            contIndex[i] = i;
            ++i;
        }
        return new OpenSocketFilterImpl(new FilterBySocketId(socketIds, contIndex, fds), name);
    }

    public ResourceName[] getDependents() {
        return null;
    }

    public boolean isModifiable() {
        return false;
    }

    @Override
    public SocketFilter getFilter() {
        return this.filterElement.getFilter();
    }

    @Override
    public long calculateWriteWork() {
        return 0L;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        this.filterElement.write(writer);
    }
}

