/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.FilterBySocketFilterResource;
import com.sap.jvm.profiling.snapshot.elements.GenericElementWithResourceName;
import com.sap.jvm.profiling.snapshot.impl.net.NetOperationsAndLatenciesIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkConnectionColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkOperationsAndLatenciesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkOperationsAndLatenciesSerializer;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatencies;
import com.sap.jvm.profiling.snapshot.net.OpenSocketStatistic;
import java.io.IOException;

public final class OpenSocketStatisticImpl
extends ValueStatisticImpl<NetworkConnection, NetworkOperationsAndLatencies>
implements OpenSocketStatistic {
    protected OpenSocketStatisticImpl(ResourceName name) {
        super(name, new NetworkConnectionColumnImpl(), new NetworkOperationsAndLatenciesColumnImpl(), new NetworkOperationsAndLatenciesSerializer());
    }

    public OpenSocketStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the socket statistic ... (<%> %)"), reporter);
    }

    public static OpenSocketStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        GenericElementWithResourceName createElement = (GenericElementWithResourceName)name.getLastElement();
        ResourceName filterName = createElement.getName();
        filterName.getResourceManager().get(filterName, reporter);
        ResourceName filteredSource = name.stripLastElement().addElement((ResourceNameElement)new FilterBySocketFilterResource(filterName));
        NetOperationsAndLatenciesIterator it = new NetOperationsAndLatenciesIterator(filteredSource, reporter, I18n._s((String)"Creating the socket statistic ... (<%> %)"));
        OpenSocketStatisticImpl result = new OpenSocketStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the socket statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<NetworkConnection, NetworkOperationsAndLatencies> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<NetworkConnection, NetworkOperationsAndLatencies> getCollector(ValueIterator<NetworkOperationsAndLatencies> rawIt) throws IOException {
            NetOperationsAndLatenciesIterator it = (NetOperationsAndLatenciesIterator)rawIt;
            ValueStatisticCollector<NetworkConnection, NetworkOperationsAndLatencies> collector = new ValueStatisticCollector<NetworkConnection, NetworkOperationsAndLatencies>(NetworkOperationsAndLatencies.EMPTY);
            while (it.next()) {
                collector.add(it.getNetworkConnection(), it.getValue());
                collector.add(it.getValue());
            }
            return collector;
        }
    }
}

