/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.net.NetOperationsAndLatenciesIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkOperationsAndLatenciesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkServiceColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkOperationsAndLatenciesSerializer;
import com.sap.jvm.profiling.snapshot.net.NetworkOperationsAndLatencies;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import com.sap.jvm.profiling.snapshot.net.ServiceStatistic;
import java.io.IOException;

public final class ServiceStatisticImpl
extends ValueStatisticImpl<NetworkService, NetworkOperationsAndLatencies>
implements ServiceStatistic {
    protected ServiceStatisticImpl(ResourceName name) {
        super(name, new NetworkServiceColumnImpl(), new NetworkOperationsAndLatenciesColumnImpl(), new NetworkOperationsAndLatenciesSerializer());
    }

    public ServiceStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the service statistic ... (<%> %)"), reporter);
    }

    public static ServiceStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        NetOperationsAndLatenciesIterator it = new NetOperationsAndLatenciesIterator(name, reporter, I18n._s((String)"Creating the service statistic ... (<%> %)"));
        ServiceStatisticImpl result = new ServiceStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the service statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<NetworkService, NetworkOperationsAndLatencies> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<NetworkService, NetworkOperationsAndLatencies> getCollector(ValueIterator<NetworkOperationsAndLatencies> rawIt) throws IOException {
            NetOperationsAndLatenciesIterator it = (NetOperationsAndLatenciesIterator)rawIt;
            ValueStatisticCollector<NetworkService, NetworkOperationsAndLatencies> collector = new ValueStatisticCollector<NetworkService, NetworkOperationsAndLatencies>(NetworkOperationsAndLatencies.EMPTY);
            while (it.next()) {
                collector.add(it.getNetworkService(), it.getValue());
                collector.add(it.getValue());
            }
            return collector;
        }
    }
}

