/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.net;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkLatenciesIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkLatenciesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.NetworkLatencyIdColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.NetworkLatenciesSerializer;
import com.sap.jvm.profiling.snapshot.net.NetworkLatencies;
import com.sap.jvm.profiling.snapshot.net.SocketLatencyStatistic;
import com.sap.jvm.profiling.snapshot.resource.NetworkLatencyId;
import java.io.IOException;

public final class SocketLatencyStatisticImpl
extends ValueStatisticImpl<NetworkLatencyId, NetworkLatencies>
implements SocketLatencyStatistic {
    protected SocketLatencyStatisticImpl(ResourceName name) {
        super(name, new NetworkLatencyIdColumn(), new NetworkLatenciesColumnImpl(), new NetworkLatenciesSerializer());
    }

    public SocketLatencyStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the socket latency statistic ... (<%> %)"), reporter);
    }

    public static SocketLatencyStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        NetworkLatenciesIterator it = new NetworkLatenciesIterator(name, reporter, I18n._s((String)"Creating the socket latency statistic ... (<%> %)"));
        SocketLatencyStatisticImpl result = new SocketLatencyStatisticImpl(name);
        new Creator().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the socket latency statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<NetworkLatencyId, NetworkLatencies> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<NetworkLatencyId, NetworkLatencies> getCollector(ValueIterator<NetworkLatencies> rawIt) throws IOException {
            NetworkLatenciesIterator it = (NetworkLatenciesIterator)rawIt;
            ValueStatisticCollector<NetworkLatencyId, NetworkLatencies> collector = new ValueStatisticCollector<NetworkLatencyId, NetworkLatencies>(NetworkLatencies.EMPTY);
            long id = 0L;
            while (it.next()) {
                NetworkLatencies value = it.getValue();
                if (value.getReadWriteLatencyCount() <= 0L && value.getWriteReadLatencyCount() <= 0L) continue;
                collector.add(new NetworkLatencyId(id++, it.getTimestamp()), value);
                collector.add(value);
            }
            return collector;
        }
    }
}

