/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.elements.MethodParameterFilterElement;
import com.sap.jvm.profiling.snapshot.elements.ThreadFilterElement;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodParameterFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.RootIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.StackExtractor;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.rootfinder.ThreadAwareRootFinderElement;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;

public abstract class AbstractValueIterator<V extends Value<V>>
implements ValueIterator<V> {
    public static final int VALUE_AVAILABLE = 0;
    public static final int READ_PERFORMED = 1;
    public static final int FINISHED = 2;
    private final boolean usesEvents;
    private final ResourceName name;
    private final StackExtractor extractor;
    private final boolean extractorNeedsThreadInfo;
    private final ThreadFilter threadFilter;
    private final MethodParameterFilter mptFilter;
    private final ProfilingReader reader;
    private final ThreadManager threadManager;

    protected AbstractValueIterator(ResourceName name, Snapshot snapshot, ProgressReporter reporter) throws OperationCanceledException {
        this.usesEvents = snapshot != null;
        this.name = name;
        this.reader = snapshot != null ? snapshot.getEventReader(reporter) : null;
        this.threadManager = this.reader != null ? this.reader.getThreadManager() : null;
        this.extractor = new StackExtractor(name, this.reader != null);
        this.extractorNeedsThreadInfo = this.extractor.needsThreadInfo();
        this.threadFilter = this.getThreadFilter();
        this.mptFilter = this.getMethodParameterFilter();
    }

    protected AbstractValueIterator(ResourceName name, ProfilingReader reader) {
        this.usesEvents = reader != null;
        this.name = name;
        this.reader = reader;
        this.threadManager = reader != null ? reader.getThreadManager() : null;
        this.extractor = new StackExtractor(name, reader != null);
        this.extractorNeedsThreadInfo = this.extractor.needsThreadInfo();
        this.threadFilter = this.getThreadFilter();
        this.mptFilter = this.getMethodParameterFilter();
    }

    @Override
    public final ResourceName getResourceName() {
        return this.name;
    }

    @Override
    public final ProfilingReader getEventReader() {
        return this.reader;
    }

    public final ThreadManager getThreadManager() {
        return this.threadManager;
    }

    @Override
    public final boolean next() throws IOException {
        if (this.usesEvents) {
            int result;
            while ((result = this.nextOrRead()) != 2) {
                if (result != 0) continue;
                return true;
            }
            return false;
        }
        assert (!this.extractorNeedsThreadInfo);
        while (this.nextFromStatistic()) {
            if (!this.extractor.setStack(this.getStackIndex())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean usesEvents() {
        return this.usesEvents;
    }

    @Override
    public final int nextOrRead() throws IOException {
        assert (this.usesEvents);
        int result = this.nextOrReadRaw();
        if (result == 0) {
            return this.filterEvent() ? 0 : 1;
        }
        return result;
    }

    private final boolean filterEvent() {
        ThreadInfo threadInfo = null;
        if (this.threadFilter != null && !this.threadFilter.applies(threadInfo = this.getThreadInfo())) {
            return false;
        }
        if (this.mptFilter != null) {
            ThreadInfo threadInfo2 = threadInfo = threadInfo == null ? this.getThreadInfo() : threadInfo;
            if (!this.mptFilter.matchesAll(threadInfo)) {
                return false;
            }
        }
        if (this.extractorNeedsThreadInfo) {
            ThreadInfo threadInfo3 = threadInfo = threadInfo == null ? this.getThreadInfo() : threadInfo;
            if (!this.extractor.setStack(this.getStackIndex(), threadInfo)) {
                return false;
            }
        } else if (!this.extractor.setStack(this.getStackIndex())) {
            return false;
        }
        return true;
    }

    protected abstract int nextOrReadRaw() throws IOException;

    protected abstract boolean nextFromStatistic() throws OperationCanceledException;

    @Override
    public final ResourceName getDependent() {
        if (this.usesEvents) {
            return null;
        }
        return this.getDependentForIt();
    }

    protected abstract ResourceName getDependentForIt();

    private ThreadFilter getThreadFilter() {
        ThreadFilter filter = null;
        for (ResourceNameElement element : this.name.getElements()) {
            if (!(element instanceof ThreadFilterElement)) continue;
            ThreadFilterElement filterElement = (ThreadFilterElement)element;
            if (filter == null) {
                filter = filterElement.getFilter();
                continue;
            }
            filter = filter.copy();
            filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    protected MethodParameterFilter getMethodParameterFilter() {
        MethodParameterFilter filter = null;
        for (ResourceNameElement element : this.name.getElements()) {
            if (!(element instanceof MethodParameterFilterElement)) continue;
            if (filter == null) {
                filter = new MethodParameterFilter();
            }
            MethodParameterFilterElement filterElement = (MethodParameterFilterElement)element;
            filterElement.addToFilter(filter);
        }
        return filter;
    }

    @Override
    public int getBottomRoot() {
        return this.extractor.getBottomRoot();
    }

    @Override
    public RootIterator getBottomToTopRootIterator() {
        return this.extractor.getBottomToTopRootIterator();
    }

    @Override
    public ClassObject getInlinedAwayClass() {
        return this.extractor.getInlinedAwayClass();
    }

    @Override
    public ClassLoaderObject getInlinedAwayClassLoader() {
        return this.extractor.getInlinedAwayClassLoader();
    }

    @Override
    public MethodObject getInlinedAwayMethod() {
        return this.extractor.getInlinedAwayMethod();
    }

    @Override
    public PackageName getInlinedAwayPackage() {
        return this.extractor.getInlinedAwayPackage();
    }

    @Override
    public MethodFilter getInlineFilter() {
        return this.extractor.getInlineFilter();
    }

    @Override
    public MethodFilter getMethodFilter() {
        return this.extractor.getMethodFilter();
    }

    @Override
    public StackFrames getStack() {
        return this.extractor.getStack();
    }

    @Override
    public ThreadInfo getThreadInfo() {
        return this.threadManager.getThreadInfo(this.getThreadIndex());
    }

    @Override
    public int getTopNonSelfRoot() {
        return this.extractor.getTopNonSelfRoot();
    }

    @Override
    public int getTopSelfRoot() {
        return this.extractor.getTopSelfRoot();
    }

    @Override
    public RootIterator getTopToBottomRootIterator() {
        return this.extractor.getTopToBottomRootIterator();
    }

    @Override
    public boolean hasSelfRoot() {
        return this.extractor.hasSelfRoot();
    }

    @Override
    public boolean isInlinedAwayCalled(int index) {
        return this.extractor.isInlinedAwayCalled(index);
    }

    @Override
    public boolean isInlinedAwayCalling(int index) {
        return this.extractor.isInlinedAwayCalling(index);
    }

    @Override
    public boolean isSelfRoot(int root) {
        return this.extractor.isSelfRoot(root);
    }

    @Override
    public boolean isTopOfStack(int index) {
        return this.extractor.isTopOfStack(index);
    }

    @Override
    public int getTopOfStackIndex() {
        return this.extractor.getTopOfStackIndex();
    }

    @Override
    public abstract V getEmptyValue();

    @Override
    public abstract V getValue();

    public ProfilingSession getSession() {
        return this.extractor.getSession();
    }

    protected static boolean needsEventIteration(ResourceName name) {
        for (ResourceNameElement element : name) {
            if (!(element instanceof ThreadAwareRootFinderElement)) continue;
            return true;
        }
        return false;
    }
}

