/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.resource;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.MPTExitValueOracle;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.AbstractId2DataOracle;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;
import java.util.ArrayList;

public class MptIteratorAdaptor<V extends Value<V>>
extends AbstractValueIterator<V>
implements MethodParameterEventHandler {
    private final ValueIterator<V> it;
    private final ProfilingReader reader;
    private MethodParameterEntryEvent entry;
    private MethodParameterEntryEvent activeEntry;
    private MethodParameterExitEvent exit;
    private MethodParameterExitEvent activeExit;
    private ThreadInfo threadInfoToUndo;
    private final AbstractId2DataOracle.DataReader<ArrayList<Parameter>> oracleReader;

    public MptIteratorAdaptor(ValueIterator<V> it) throws IOException {
        super(it.getResourceName(), it.getEventReader());
        this.it = it;
        this.reader = this.getEventReader();
        this.reader.registerMethodParameterEventHandler((MethodParameterEventHandler)this);
        MPTExitValueOracle oracle = MPTExitValueOracle.get(it.getResourceName(), it.getReporter());
        this.oracleReader = oracle == null ? null : oracle.getReader(this.getSession());
    }

    @Override
    protected ResourceName getDependentForIt() {
        return this.it.getDependent();
    }

    @Override
    public V getEmptyValue() {
        return this.it.getEmptyValue();
    }

    @Override
    public int getStackIndex() {
        if (this.activeEntry != null) {
            return this.activeEntry.getStackTraceIndex();
        }
        if (this.activeExit != null) {
            return this.activeExit.getEntryEvent() == null ? 0 : this.activeExit.getEntryEvent().getStackTraceIndex();
        }
        return this.it.getStackIndex();
    }

    @Override
    public char getThreadIndex() {
        if (this.activeEntry != null) {
            return this.activeEntry.getThreadIndex();
        }
        if (this.activeExit != null) {
            return this.activeExit.getThreadIndex();
        }
        return this.it.getThreadIndex();
    }

    @Override
    public V getValue() {
        return this.it.getValue();
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int nextOrReadRaw() throws IOException {
        if (this.threadInfoToUndo != null) {
            this.threadInfoToUndo.undoEntryStackChanges();
            this.threadInfoToUndo = null;
        }
        if (this.entry != null) {
            this.activeEntry = this.entry;
            this.getThreadManager().getThreadInfo(this.entry.getThreadIndex()).undoEntryStackChanges();
            this.entry = null;
            return 0;
        }
        if (this.exit != null) {
            this.activeExit = this.exit;
            this.threadInfoToUndo = this.getThreadManager().getThreadInfo(this.exit.getThreadIndex());
            this.exit = null;
            return 0;
        }
        this.activeEntry = null;
        this.activeExit = null;
        int result = this.it.nextOrRead();
        if (result == 1 && (this.entry != null || this.exit != null)) {
            return this.nextOrReadRaw();
        }
        return result;
    }

    public boolean isEntry() {
        return this.activeEntry != null;
    }

    public boolean isExit() {
        return this.activeExit != null;
    }

    public MethodParameterEntryEvent getEntryEvent() {
        return this.activeEntry;
    }

    public MethodParameterExitEvent getExitEvent() {
        return this.activeExit;
    }

    public void handle(EnableMethodParameterTraceResponse response) {
    }

    public void handle(DisableMethodParameterTraceResponse response) {
    }

    public void handle(MethodParameterEntryEvent event) {
        this.entry = event;
    }

    public void handle(MethodParameterExitEvent event) {
        this.exit = event;
    }

    public void handle(MethodParameterNearMissEvent event) {
    }

    public void handle(MethodParameterApplyErrorEvent event) {
    }

    public boolean providesReturnValuesInEntryEvents() {
        return this.oracleReader != null;
    }

    public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) throws IOException {
        return this.oracleReader.getData(event.getId());
    }

    @Override
    public ProgressReporter getReporter() {
        return this.it.getReporter();
    }
}

