/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.core.type.StackTraceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.elements.SetBottomOfStackAsRoots;
import com.sap.jvm.profiling.snapshot.elements.SwitchToBlocked;
import com.sap.jvm.profiling.snapshot.elements.SwitchToBlocking;
import com.sap.jvm.profiling.snapshot.elements.SwitchToCalled;
import com.sap.jvm.profiling.snapshot.elements.SwitchToCalling;
import com.sap.jvm.profiling.snapshot.elements.UndoLastStackExtractorStep;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilterElement;
import com.sap.jvm.profiling.snapshot.impl.resource.BottomtToTopRootIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.RootIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.StackIterationResult;
import com.sap.jvm.profiling.snapshot.impl.resource.TopToBottomRootIterator;
import com.sap.jvm.profiling.snapshot.resource.InlineFilterExtractor;
import com.sap.jvm.profiling.snapshot.rootfinder.BottomOfStackRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinderElement;
import com.sap.jvm.profiling.snapshot.rootfinder.CallingRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CallingRootFinderElement;
import com.sap.jvm.profiling.snapshot.rootfinder.ThreadAwareRootFinder;
import com.sap.jvm.profiling.util.IntArrayList;
import java.util.ArrayList;

public class StackExtractor
implements StackIterationResult {
    private static final int APPLY_CALLED_ROOT_FINDER = 0;
    private static final int APPLY_CALLING_ROOT_FINDER = 1;
    private static final int CALLED_TO_CALLING = 2;
    private static final int CALLING_TO_CALLED = 3;
    private MethodFilter methodFilter;
    private boolean isSimple;
    private boolean isCalledAtEnd;
    private StackFrames stack;
    private IntArrayList selfRoots;
    private IntArrayList nonSelfRoots;
    private IntArrayList selfRootsOut;
    private IntArrayList nonSelfRootsOut;
    private CalledRootFinder[] calledRootFinders;
    private CallingRootFinder[] callingRootFinders;
    private MethodFilter inlineFilter;
    private MethodFilter[] inlineFilterParts;
    private ThreadAwareRootFinder[] threadAwareRootFinders;
    private int[] tags;
    private int nrOfSteps;
    private StackTraceManager stackManager;
    private boolean isValid;
    private boolean selfSorted;
    private boolean nonSelfSorted;
    private final ResourceName name;
    private int inlineTop;
    private int inlineBottom;
    private final MethodObject inlinedAwayMethod;
    private final ClassObject inlinedAwayClass;
    private final ClassLoaderObject inlinedAwayClassLoader;
    private final PackageName inlinedAwayPackage;

    public StackExtractor(ResourceName name, boolean useCache) {
        this.name = name;
        this.stackManager = name.getSession().getStackTraceManager();
        this.stack = this.stackManager.getStackFramesObject(useCache);
        this.selfRoots = new IntArrayList();
        this.nonSelfRoots = new IntArrayList();
        this.selfRootsOut = new IntArrayList();
        this.nonSelfRootsOut = new IntArrayList();
        this.calledRootFinders = new CalledRootFinder[1];
        this.callingRootFinders = new CallingRootFinder[1];
        this.tags = new int[1];
        this.inlineFilterParts = new MethodFilter[1];
        this.isCalledAtEnd = true;
        this.inlineFilter = InlineFilterExtractor.getInlineFilter(name);
        this.inlinedAwayMethod = this.getSession().getMethodLocationManager().getInlinedAwayMethodLocation().getMethod();
        this.inlinedAwayClass = this.inlinedAwayMethod.getMethodClass();
        this.inlinedAwayClassLoader = this.inlinedAwayClass.getClassLoader();
        this.inlinedAwayPackage = this.getSession().getPackageNameManager().getInlinedAwayPackageName();
        ResourceName partName = null;
        for (ResourceNameElement element : name.getElements()) {
            if (element instanceof SnapshotEndTag || element instanceof SwitchToBlocked || element instanceof SwitchToBlocking) {
                if (!this.isCalledAtEnd) {
                    this.processCallingToCalled(new SwitchToCalled());
                }
                if (this.nrOfSteps > 0) {
                    this.processCalledRootFinder(new SetBottomOfStackAsRoots());
                }
            } else {
                this.processMethodFilter(element);
                this.processCalledToCalling(element, partName);
                this.processCallingToCalled(element);
                this.processCalledRootFinder(element);
                this.processCallingRootFinder(element);
                this.processUndoStep(element);
            }
            partName = partName != null ? partName.addElement(element) : this.getSession().getResourceManager().createResourceName(element);
        }
        if (this.nrOfSteps == 0) {
            this.isSimple = true;
            this.isValid = true;
        }
        ArrayList<ThreadAwareRootFinder> tmp = new ArrayList<ThreadAwareRootFinder>();
        for (CalledRootFinder calledRootFinder : this.calledRootFinders) {
            if (!(calledRootFinder instanceof ThreadAwareRootFinder)) continue;
            tmp.add((ThreadAwareRootFinder)((Object)calledRootFinder));
        }
        for (CallingRootFinder callingRootFinder : this.callingRootFinders) {
            if (!(callingRootFinder instanceof ThreadAwareRootFinder)) continue;
            tmp.add((ThreadAwareRootFinder)((Object)callingRootFinder));
        }
        if (!tmp.isEmpty()) {
            this.threadAwareRootFinders = tmp.toArray(new ThreadAwareRootFinder[tmp.size()]);
            for (ThreadAwareRootFinder threadAwareRootFinder : this.threadAwareRootFinders) {
                threadAwareRootFinder.setSession(name.getSession());
            }
        }
    }

    private void addStep(int tag) {
        this.tags[this.nrOfSteps] = tag;
        ++this.nrOfSteps;
        CalledRootFinder[] newCalledRootFinders = new CalledRootFinder[this.nrOfSteps + 1];
        System.arraycopy(this.calledRootFinders, 0, newCalledRootFinders, 0, this.nrOfSteps);
        this.calledRootFinders = newCalledRootFinders;
        CallingRootFinder[] newCallingRootFinders = new CallingRootFinder[this.nrOfSteps + 1];
        System.arraycopy(this.callingRootFinders, 0, newCallingRootFinders, 0, this.nrOfSteps);
        this.callingRootFinders = newCallingRootFinders;
        int[] newTags = new int[this.nrOfSteps + 1];
        System.arraycopy(this.tags, 0, newTags, 0, this.nrOfSteps);
        this.tags = newTags;
        MethodFilter[] newInlineFilterParts = new MethodFilter[this.nrOfSteps + 1];
        System.arraycopy(this.inlineFilterParts, 0, newInlineFilterParts, 0, this.nrOfSteps);
        this.inlineFilterParts = newInlineFilterParts;
    }

    private void processMethodFilter(ResourceNameElement element) {
        if (element instanceof MethodFilterElement) {
            MethodFilterElement filterElement = (MethodFilterElement)element;
            MethodFilter toAdd = filterElement.getMethodFilter();
            this.methodFilter = this.methodFilter == null ? toAdd : this.methodFilter.narrow("<artificial>", toAdd, false);
        }
    }

    private void processCalledToCalling(ResourceNameElement element, ResourceName part) {
        if (element instanceof SwitchToCalling) {
            assert (this.isCalledAtEnd);
            this.isCalledAtEnd = false;
            this.inlineFilterParts[this.nrOfSteps] = InlineFilterExtractor.getInlineFilter(part);
            this.addStep(2);
        }
    }

    private void processCalledRootFinder(ResourceNameElement element) {
        if (element instanceof CalledRootFinderElement) {
            assert (this.isCalledAtEnd);
            this.calledRootFinders[this.nrOfSteps] = ((CalledRootFinderElement)element).createRootFinder();
            this.addStep(0);
        }
    }

    private void processCallingRootFinder(ResourceNameElement element) {
        if (element instanceof CallingRootFinderElement) {
            assert (!this.isCalledAtEnd);
            this.callingRootFinders[this.nrOfSteps] = ((CallingRootFinderElement)element).createRootFinder();
            this.addStep(1);
        }
    }

    private void processUndoStep(ResourceNameElement element) {
        if (element instanceof UndoLastStackExtractorStep) {
            assert (this.nrOfSteps > 0);
            --this.nrOfSteps;
        }
    }

    private void processCallingToCalled(ResourceNameElement element) {
        if (element instanceof SwitchToCalled) {
            assert (!this.isCalledAtEnd);
            this.isCalledAtEnd = true;
            this.addStep(3);
        }
    }

    public boolean needsThreadInfo() {
        return this.threadAwareRootFinders != null;
    }

    public boolean setStack(int stackIndex, ThreadInfo info) {
        assert (this.threadAwareRootFinders != null);
        for (ThreadAwareRootFinder finder : this.threadAwareRootFinders) {
            finder.setThreadInfo(info);
        }
        return this.setStackImpl(stackIndex);
    }

    public boolean setStack(int stackIndex) {
        assert (this.threadAwareRootFinders == null);
        return this.setStackImpl(stackIndex);
    }

    private boolean setStackImpl(int stackIndex) {
        this.selfRoots.clear();
        this.nonSelfRoots.clear();
        this.selfRoots.push(0);
        this.selfSorted = false;
        this.nonSelfSorted = false;
        this.inlineTop = -1;
        this.inlineBottom = -1;
        this.stack.fillAndAddNoLocation(stackIndex);
        if (this.isSimple) {
            return true;
        }
        for (int i = 0; i < this.nrOfSteps; ++i) {
            if (this.performStep(i)) continue;
            this.isValid = false;
            return false;
        }
        this.isValid = this.selfRoots.size() + this.nonSelfRoots.size() > 0;
        return this.isValid;
    }

    private boolean performStep(int step) {
        switch (this.tags[step]) {
            case 0: {
                this.performCalledRootFinderStep(step);
                break;
            }
            case 1: {
                this.performCallingRootFinderStep(step);
                break;
            }
            case 2: {
                this.performCalledToCallingStep(step);
                break;
            }
            case 3: {
                this.performCallingToCalledStep(step);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.selfRoots.size() + this.nonSelfRoots.size() > 0;
    }

    private void performCalledRootFinderStep(int step) {
        this.selfRootsOut.clear();
        this.calledRootFinders[step].getCalledRoots(this.stack, this.selfRoots, this.selfRootsOut);
        assert (this.selfRootsOut.isEmpty() || this.selfRoots.getMinValue() <= this.selfRootsOut.getMinValue() || this.calledRootFinders[step] instanceof BottomOfStackRootFinder);
        IntArrayList tmp = this.selfRoots;
        this.selfRoots = this.selfRootsOut;
        this.selfRootsOut = tmp;
    }

    private void performCallingRootFinderStep(int step) {
        this.selfRootsOut.clear();
        this.nonSelfRootsOut.clear();
        this.callingRootFinders[step].getCallingRoots(this.stack, this.selfRoots, this.nonSelfRoots, this.selfRootsOut, this.nonSelfRootsOut);
        assert (this.selfRootsOut.isEmpty() || this.selfRoots.getMaxValue() >= this.selfRootsOut.getMaxValue());
        assert (this.nonSelfRootsOut.isEmpty() || this.nonSelfRoots.getMaxValue() >= this.nonSelfRootsOut.getMaxValue());
        IntArrayList tmp = this.selfRoots;
        this.selfRoots = this.selfRootsOut;
        this.selfRootsOut = tmp;
        tmp = this.nonSelfRoots;
        this.nonSelfRoots = this.nonSelfRootsOut;
        this.nonSelfRootsOut = tmp;
    }

    private void performCallingToCalledStep(int step) {
        for (int i = 0; i < this.nonSelfRoots.size(); ++i) {
            this.selfRoots.push(this.nonSelfRoots.get(i));
        }
    }

    private void performCalledToCallingStep(int step) {
        this.selfRootsOut.clear();
        this.nonSelfRoots.clear();
        for (int i = 0; i < this.selfRoots.size(); ++i) {
            int root = this.selfRoots.get(i);
            MethodFilter oldFilter = this.inlineFilter;
            this.inlineFilter = this.inlineFilterParts[step];
            this.inlineTop = -1;
            if (this.isTopOfStack(root)) {
                this.selfRootsOut.push(root);
            } else {
                this.nonSelfRoots.push(root);
            }
            this.inlineTop = -1;
            this.inlineFilter = oldFilter;
        }
        IntArrayList tmp = this.selfRoots;
        this.selfRoots = this.selfRootsOut;
        this.selfRootsOut = tmp;
    }

    @Override
    public StackFrames getStack() {
        assert (this.isValid);
        return this.stack;
    }

    @Override
    public MethodFilter getMethodFilter() {
        return this.methodFilter;
    }

    private int getSelfRootsMinValue() {
        if (this.selfSorted) {
            return this.selfRoots.get(0);
        }
        return this.selfRoots.getMinValue();
    }

    private int getSelfRootsMaxValue() {
        if (this.selfSorted) {
            return this.selfRoots.get(this.selfRoots.size() - 1);
        }
        return this.selfRoots.getMaxValue();
    }

    private int getNonSelfRootsMaxValue() {
        if (this.nonSelfSorted) {
            return this.nonSelfRoots.get(this.nonSelfRoots.size() - 1);
        }
        return this.nonSelfRoots.getMaxValue();
    }

    private int getNonSelfRootsMinValue() {
        if (this.nonSelfSorted) {
            return this.nonSelfRoots.get(0);
        }
        return this.nonSelfRoots.getMinValue();
    }

    @Override
    public int getBottomRoot() {
        assert (this.isCalledAtEnd);
        if (this.selfRoots.isEmpty()) {
            return this.getNonSelfRootsMinValue();
        }
        if (this.nonSelfRoots.isEmpty()) {
            return this.getSelfRootsMinValue();
        }
        return Math.min(this.getSelfRootsMinValue(), this.getNonSelfRootsMinValue());
    }

    @Override
    public RootIterator getBottomToTopRootIterator() {
        if (!this.selfSorted) {
            this.selfRoots.sortAscendingAndUnique();
            this.selfSorted = true;
        }
        if (!this.nonSelfSorted) {
            this.nonSelfRoots.sortAscendingAndUnique();
            this.nonSelfSorted = true;
        }
        return new BottomtToTopRootIterator(this.selfRoots, this.nonSelfRoots);
    }

    @Override
    public int getTopSelfRoot() {
        assert (!this.isCalledAtEnd);
        if (this.selfRoots.isEmpty()) {
            return -1;
        }
        return this.getSelfRootsMaxValue();
    }

    @Override
    public int getTopNonSelfRoot() {
        assert (!this.isCalledAtEnd);
        if (this.nonSelfRoots.isEmpty()) {
            return -1;
        }
        return this.getNonSelfRootsMaxValue();
    }

    @Override
    public RootIterator getTopToBottomRootIterator() {
        if (!this.selfSorted) {
            this.selfRoots.sortAscendingAndUnique();
            this.selfSorted = true;
        }
        if (!this.nonSelfSorted) {
            this.nonSelfRoots.sortAscendingAndUnique();
            this.nonSelfSorted = true;
        }
        return new TopToBottomRootIterator(this.selfRoots, this.nonSelfRoots);
    }

    @Override
    public boolean hasSelfRoot() {
        if (this.isCalledAtEnd) {
            return !this.selfRoots.isEmpty() && this.isTopOfStack(this.selfRoots.getMaxValue());
        }
        return !this.selfRoots.isEmpty();
    }

    private int getInlineTop() {
        if (this.inlineTop < 0) {
            this.inlineTop = 0;
            for (int i = this.stack.getNrOfFrames() - 1; i >= 0; --i) {
                if (this.inlineFilter.matches(this.stack.getMethod(i))) continue;
                this.inlineTop = i + 1;
                break;
            }
        }
        return this.inlineTop;
    }

    private int getInlineBottom() {
        if (this.inlineBottom < 0) {
            this.inlineBottom = this.stack.getNrOfFrames();
            for (int i = 0; i < this.inlineBottom; ++i) {
                if (this.inlineFilter.matches(this.stack.getMethod(i))) continue;
                this.inlineBottom = i;
                break;
            }
        }
        return this.inlineBottom;
    }

    @Override
    public boolean isSelfRoot(int root) {
        assert (!this.isCalledAtEnd);
        if (!this.selfSorted) {
            this.selfRoots.sortAscendingAndUnique();
            this.selfSorted = true;
        }
        return this.selfRoots.contains(root);
    }

    public String toString() {
        return "Stack extractor for " + this.name;
    }

    @Override
    public MethodFilter getInlineFilter() {
        return this.inlineFilter;
    }

    @Override
    public boolean isTopOfStack(int index) {
        return index >= this.getTopOfStackIndex();
    }

    @Override
    public int getTopOfStackIndex() {
        if (this.inlineFilter != null) {
            return this.getInlineTop() - 1;
        }
        return this.stack.getNrOfFrames() - 1;
    }

    @Override
    public boolean isInlinedAwayCalled(int index) {
        if (this.inlineFilter == null) {
            return false;
        }
        return index >= this.getInlineTop();
    }

    @Override
    public boolean isInlinedAwayCalling(int index) {
        if (this.inlineFilter == null) {
            return false;
        }
        return index < this.getInlineBottom();
    }

    public ProfilingSession getSession() {
        return this.name.getSession();
    }

    @Override
    public ClassObject getInlinedAwayClass() {
        return this.inlinedAwayClass;
    }

    @Override
    public ClassLoaderObject getInlinedAwayClassLoader() {
        return this.inlinedAwayClassLoader;
    }

    @Override
    public MethodObject getInlinedAwayMethod() {
        return this.inlinedAwayMethod;
    }

    @Override
    public PackageName getInlinedAwayPackage() {
        return this.inlinedAwayPackage;
    }
}

