/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.SynchronizationEventIdColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeAndCountColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndCountSerializer;
import com.sap.jvm.profiling.snapshot.resource.SynchronizationEventId;
import com.sap.jvm.profiling.snapshot.sync.BlockedEventStatistic;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import com.sap.jvm.profiling.sync.event.SyncEnterEvent;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import java.io.IOException;

public class BlockedEventStatisticImpl
extends ValueStatisticImpl<SynchronizationEventId, TimeAndCount>
implements BlockedEventStatistic {
    protected BlockedEventStatisticImpl(ResourceName name) {
        super(name, new SynchronizationEventIdColumn(), new TimeAndCountColumnImpl(), new TimeAndCountSerializer());
    }

    public BlockedEventStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the block event statistic ... (<%> %)"), reporter);
    }

    public static BlockedEventStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        SynchronizationEventIteratorImpl it = new SynchronizationEventIteratorImpl(name, reporter, I18n._s((String)"Creating the block event statistic ... (<%> %)"), false);
        BlockedEventStatisticImpl result = new BlockedEventStatisticImpl(name);
        ValueStatisticCollector<SynchronizationEventId, TimeAndCount> collector = new ValueStatisticCollector<SynchronizationEventId, TimeAndCount>(it.getEmptyValue());
        SynchronizationEventId[] idsPerThread = new SynchronizationEventId[32768];
        long currentIndex = 0L;
        while (it.next()) {
            SynchronizationEventId currentId;
            SyncEnterEvent enterEvent = it.getEnterEvent();
            if (enterEvent != null) {
                long id = enterEvent.getId();
                ++currentIndex;
                assert (idsPerThread[enterEvent.getThreadIndex()] == null);
                idsPerThread[enterEvent.getThreadIndex()] = currentId = new SynchronizationEventId(id, currentIndex);
            } else {
                assert (it.getEnteredEvent() != null);
                SyncEnteredEvent exitEvent = it.getEnteredEvent();
                if (idsPerThread[exitEvent.getThreadIndex()] == null) continue;
                assert (idsPerThread[exitEvent.getThreadIndex()] != null);
                currentId = idsPerThread[exitEvent.getThreadIndex()];
                idsPerThread[exitEvent.getThreadIndex()] = null;
            }
            TimeAndCount val = it.getValue();
            collector.add(currentId, val);
            collector.add(val);
        }
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the block event statistic ... (<%> %)"), reporter);
    }
}

