/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync;

import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.MonitorObjectColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeAndCountColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndCountSerializer;
import com.sap.jvm.profiling.snapshot.sync.BlockedMonitorStatistic;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import java.io.IOException;

public class BlockedMonitorStatisticImpl
extends ValueStatisticImpl<MonitorObject, TimeAndCount>
implements BlockedMonitorStatistic {
    protected BlockedMonitorStatisticImpl(ResourceName name) {
        super(name, new MonitorObjectColumnImpl(name.getSession()), new TimeAndCountColumnImpl(), new TimeAndCountSerializer());
    }

    public BlockedMonitorStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the monitor statistic ... (<%> %)"), reporter);
    }

    public static BlockedMonitorStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        SynchronizationEventIteratorImpl it = new SynchronizationEventIteratorImpl(name, reporter, I18n._s((String)"Creating the monitor statistic ... (<%> %)"), false);
        BlockedMonitorStatisticImpl result = new BlockedMonitorStatisticImpl(name);
        ValueStatisticCollector<MonitorObject, TimeAndCount> collector = new ValueStatisticCollector<MonitorObject, TimeAndCount>(it.getEmptyValue());
        while (it.next()) {
            MonitorObject monitor2 = it.getMonitorObject();
            if (monitor2 == null) continue;
            TimeAndCount val = it.getValue();
            collector.add(monitor2, val);
            collector.add(val);
        }
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the monitor statistic ... (<%> %)"), reporter);
    }
}

