/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.ReentrantLockColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeAndCountColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndCountSerializer;
import com.sap.jvm.profiling.snapshot.sync.BlockedReentrantLockStatistic;
import com.sap.jvm.profiling.snapshot.sync.ReentrantLockObject;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import java.io.IOException;

public class BlockedReentrantLockStatisticImpl
extends ValueStatisticImpl<ReentrantLockObject, TimeAndCount>
implements BlockedReentrantLockStatistic {
    protected BlockedReentrantLockStatisticImpl(ResourceName name) {
        super(name, new ReentrantLockColumn(), new TimeAndCountColumnImpl(), new TimeAndCountSerializer());
    }

    public BlockedReentrantLockStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the reentrant lock statistic ... (<%> %)"), reporter);
    }

    public static BlockedReentrantLockStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        SynchronizationEventIteratorImpl it = new SynchronizationEventIteratorImpl(name, reporter, I18n._s((String)"Creating the reentrant lock statistic ... (<%> %)"), false);
        BlockedReentrantLockStatisticImpl result = new BlockedReentrantLockStatisticImpl(name);
        ValueStatisticCollector<ReentrantLockObject, TimeAndCount> collector = new ValueStatisticCollector<ReentrantLockObject, TimeAndCount>(it.getEmptyValue());
        while (it.next()) {
            ReentrantLockObject lock = it.getReentrantLockObject();
            if (lock == null) continue;
            TimeAndCount val = it.getValue();
            collector.add(lock, val);
            collector.add(val);
        }
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the reentrant lock statistic ... (<%> %)"), reporter);
    }
}

