/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeAndCountColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.UTF8StringColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ThreadNameStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndCountSerializer;
import com.sap.jvm.profiling.snapshot.sync.BlockedThreadNameStatistic;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import java.io.IOException;

public final class BlockedThreadNameStatisticImpl
extends ValueStatisticImpl<UTF8String, TimeAndCount>
implements BlockedThreadNameStatistic {
    protected BlockedThreadNameStatisticImpl(ResourceName name) {
        super(name, new UTF8StringColumn(), new TimeAndCountColumnImpl(), new TimeAndCountSerializer());
    }

    public BlockedThreadNameStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the blocked thread name statistic ... (<%> %)"), reporter);
    }

    public static BlockedThreadNameStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        SynchronizationEventIteratorImpl it = new SynchronizationEventIteratorImpl(name, reporter, I18n._s((String)"Creating the blocked thread name statistic ... (<%> %)"), false);
        BlockedThreadNameStatisticImpl result = new BlockedThreadNameStatisticImpl(name);
        new ThreadNameStatisticCreator<TimeAndCount>().fillInStatistic(result, it);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the blocked thread name statistic ... (<%> %)"), reporter);
    }
}

