/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationBlockingEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.SynchronizationEventIdColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeAndCountColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndCountSerializer;
import com.sap.jvm.profiling.snapshot.resource.SynchronizationEventId;
import com.sap.jvm.profiling.snapshot.sync.BlockingEventStatistic;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import java.io.IOException;

public class BlockingEventStatisticImpl
extends ValueStatisticImpl<SynchronizationEventId, TimeAndCount>
implements BlockingEventStatistic {
    protected BlockingEventStatisticImpl(ResourceName name) {
        super(name, new SynchronizationEventIdColumn(), new TimeAndCountColumnImpl(), new TimeAndCountSerializer());
    }

    public BlockingEventStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the blocking event statistic ... (<%> %)"), reporter);
    }

    public static BlockingEventStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        SynchronizationBlockingEventIteratorImpl it = new SynchronizationBlockingEventIteratorImpl(name, reporter, I18n._s((String)"Creating the blocking event statistic ... (<%> %)"));
        BlockingEventStatisticImpl result = new BlockingEventStatisticImpl(name);
        ValueStatisticCollector<SynchronizationEventId, TimeAndCount> collector = new ValueStatisticCollector<SynchronizationEventId, TimeAndCount>(it.getEmptyValue());
        long currentIndex = 0L;
        while (it.next()) {
            SynchronizationEventId id = new SynchronizationEventId(it.getId(), ++currentIndex);
            TimeAndCount val = it.getValue();
            collector.add(id, val);
            collector.add(val);
        }
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the blocking event statistic ... (<%> %)"), reporter);
    }
}

