/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationBlockingEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.ReentrantLockColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.TimeAndCountColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.TimeAndCountSerializer;
import com.sap.jvm.profiling.snapshot.sync.BlockingReentrantLockStatistic;
import com.sap.jvm.profiling.snapshot.sync.ReentrantLockObject;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import java.io.IOException;

public class BlockingReentrantLockStatisticImpl
extends ValueStatisticImpl<ReentrantLockObject, TimeAndCount>
implements BlockingReentrantLockStatistic {
    protected BlockingReentrantLockStatisticImpl(ResourceName name) {
        super(name, new ReentrantLockColumn(), new TimeAndCountColumnImpl(), new TimeAndCountSerializer());
    }

    public BlockingReentrantLockStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the reentrant lock statistic ... (<%> %)"), reporter);
    }

    public static BlockingReentrantLockStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        SynchronizationBlockingEventIteratorImpl it = new SynchronizationBlockingEventIteratorImpl(name, reporter, I18n._s((String)"Creating the reentrant lock statistic ... (<%> %)"));
        BlockingReentrantLockStatisticImpl result = new BlockingReentrantLockStatisticImpl(name);
        ValueStatisticCollector<ReentrantLockObject, TimeAndCount> collector = new ValueStatisticCollector<ReentrantLockObject, TimeAndCount>(it.getEmptyValue());
        while (it.next()) {
            ReentrantLockObject lock = it.getReentrantLockObject();
            if (lock == null) continue;
            TimeAndCount val = it.getValue();
            collector.add(lock, val);
            collector.add(val);
        }
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the reentrant lock statistic ... (<%> %)"), reporter);
    }
}

