/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.sync.util.SynchronizationEventIteratorImpl;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationSnapshot;
import com.sap.jvm.profiling.snapshot.sync.TimeAndCount;
import com.sap.jvm.profiling.sync.command.SynchronizationTraceConfiguration;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class SynchronizationSnapshotImpl
extends SnapshotImpl
implements SynchronizationSnapshot {
    private final Bookmark completeStart;
    private final Bookmark completeEnd;
    private ResourceName resourceName;
    private long nrOfBlockedEvents;
    private long blockedTime;
    private long nrOfWaitEvents;
    private final SynchronizationTraceConfiguration config;

    public static SynchronizationSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long blockEvents = reader.readInt64();
        long waitEvents = reader.readInt64();
        long blockedTimeNS = reader.readInt64();
        ThreadFilter threadFilter = reader.readNewThreadFilter();
        Bookmark completeStart = reader.hasNext() ? reader.getSession().readBookmark(reader) : start;
        Bookmark completeEnd = reader.hasNext() ? reader.getSession().readBookmark(reader) : end;
        boolean waitNotify = reader.hasNext() ? reader.readBoolean() : false;
        SynchronizationTraceConfiguration config = new SynchronizationTraceConfiguration();
        config.setThreadFilter(threadFilter);
        config.setWaitNotifyEnabled(waitNotify);
        SynchronizationSnapshotImpl snapshot = new SynchronizationSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, completeStart, completeEnd, config, blockEvents, blockedTimeNS, waitEvents, startTimestamp, endTimestamp, isVirtual, null);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public SynchronizationSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, Bookmark completeStart, Bookmark completeEnd, SynchronizationTraceConfiguration config, long nrOfBlockedEvents, long blockedTime, long nrOfWaitEvents, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, SynchronizationSnapshot parent) {
        super(SnapshotType.SYNCHRONIZATION_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.config = config;
        this.nrOfBlockedEvents = nrOfBlockedEvents;
        this.nrOfWaitEvents = nrOfWaitEvents;
        this.blockedTime = blockedTime;
        this.resourceName = resourceName;
        this.completeStart = completeStart;
        this.completeEnd = completeEnd;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public long getBlockedEvents() {
        return this.nrOfBlockedEvents;
    }

    @Override
    public long getBlockedTime() {
        return this.blockedTime;
    }

    @Override
    public long getMonitorWaitEvents() {
        return this.nrOfWaitEvents;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfBlockedEvents);
        writer.writeInt64(this.nrOfWaitEvents);
        writer.writeInt64(this.blockedTime);
        writer.writeNewThreadFilter(this.config.getThreadFilter());
        this.completeStart.write((ResourceWriter)writer);
        this.completeEnd.write((ResourceWriter)writer);
        writer.writeBoolean(this.config.isWaitNotifyEnabled());
    }

    @Override
    public ProfilingReader getEventReader(ProgressReporter reporter) throws OperationCanceledException {
        return this.getSession().getResourceManager().getEventReader(this.completeStart, this.completeEnd, null, reporter);
    }

    @Override
    public boolean isBeforeSnapshotEnd(ProfilingReader reader) {
        return reader.isBeforeBookmark(this.getEndBookmark());
    }

    @Override
    public boolean isAfterSnapshotStart(ProfilingReader reader) {
        return reader.isAfterBookmark(this.getStartBookmark());
    }

    @Override
    public Bookmark getCompleteStartBookmark() {
        return this.completeStart;
    }

    @Override
    public Bookmark getCompleteEndBookmark() {
        return this.completeEnd;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        if (this.blockedTime >= 0L && this.nrOfBlockedEvents >= 0L && this.nrOfWaitEvents >= 0L) {
            return;
        }
        this.blockedTime = 0L;
        this.nrOfBlockedEvents = 0L;
        this.nrOfWaitEvents = 0L;
        SynchronizationEventIteratorImpl it = new SynchronizationEventIteratorImpl(this.asResourceName(), reporter, I18n._s((String)"Analyzing the synchronization events ... (<%> %)"), false);
        try {
            while (it.next()) {
                TimeAndCount value = it.getValue();
                this.blockedTime += value.getDuration();
                this.nrOfBlockedEvents += value.getCount();
            }
            this.nrOfWaitEvents = it.getWaitCount();
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Failed to analyze the synchronization events");
        }
    }

    @Override
    public SynchronizationTraceConfiguration getTraceConfiguration() {
        return this.config;
    }
}

