/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.sync.util;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.sync.SynchronizationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.sync.util.BlockingThreadCache;
import com.sap.jvm.profiling.snapshot.impl.sync.util.BlockingThreadCacheIterator;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResource;
import com.sap.jvm.profiling.sync.event.SyncEnterEvent;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import com.sap.jvm.profiling.sync.event.SyncExitEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class BlockingThreadCache1
extends AbstractResource
implements SnapshotResource,
BlockingThreadCache {
    private static final int VERSION = 0;
    private long writeWork;
    private final Map<Long, List<Value>> obj2ExitEvents = new HashMap<Long, List<Value>>();
    private final Map<EnteredKey, Long> entered2LockCount = new HashMap<EnteredKey, Long>();

    private BlockingThreadCache1(ResourceName name) {
        super(name);
    }

    public BlockingThreadCache1(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        reader.readVersion(0);
        this.writeWork = reader.readInt64();
        reporter.setWork(I18n._s((String)"Reading the blocking threads information .... (<%> %)"), this.writeWork);
        int nrOfObjectIds = reader.readInt32();
        for (int i = 0; i < nrOfObjectIds; ++i) {
            long objectId = reader.readInt64();
            int nrOfValues = reader.readInt32();
            ArrayList<Value> values = new ArrayList<Value>(nrOfValues);
            for (int j = 0; j < nrOfValues; ++j) {
                reporter.reportNextOrThrow();
                values.add(new Value(reader));
            }
            this.obj2ExitEvents.put(objectId, values);
        }
        int nrOfEntered = reader.readInt32();
        for (int i = 0; i < nrOfEntered; ++i) {
            reporter.reportNextOrThrow();
            this.entered2LockCount.put(new EnteredKey(reader), reader.readInt64());
        }
    }

    public static BlockingThreadCache1 create(ResourceName name, ProgressReporter reporter) throws IOException {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(name.getSession());
        SynchronizationSnapshotImpl snapshot = (SynchronizationSnapshotImpl)manager.getSnapshot(name);
        ProfilingReader reader = snapshot.getEventReader(reporter);
        reporter.setWork(I18n._s((String)"Checking for blocking threads ... (<%> %)"), reader.getNrOfPacketsToRead());
        BlockingThreadCache1 blockingThreadCache = new BlockingThreadCache1(name);
        HashMap<SynchronizationEventKey, EnteredKey> thread2EnteredKey = new HashMap<SynchronizationEventKey, EnteredKey>();
        long[] blockedThread2ObjectId = new long[32768];
        for (int i = 0; i < blockedThread2ObjectId.length; ++i) {
            blockedThread2ObjectId[i] = -1L;
        }
        try {
            ProfilingPacket currentPacket;
            while ((currentPacket = reader.nextPacket()) != null) {
                long objectId;
                SyncExitEvent event;
                reporter.reportNextOrThrow();
                if (currentPacket instanceof SyncExitEvent) {
                    event = (SyncExitEvent)currentPacket;
                    long timestamp = event.getTimeStamp() - event.getCumulatedSafepointTime();
                    long objectId2 = event.getObjectId();
                    char threadIndex = event.getThreadIndex();
                    blockingThreadCache.add(objectId2, threadIndex, event.getLockCount(), event.getStackTraceIndex(), timestamp, event.getId());
                    EnteredKey key = (EnteredKey)thread2EnteredKey.remove(new SynchronizationEventKey(threadIndex, objectId2));
                    if (key == null) continue;
                    blockingThreadCache.entered2LockCount.put(key, event.getLockCount());
                    continue;
                }
                if (currentPacket instanceof SyncEnterEvent) {
                    event = (SyncEnterEvent)currentPacket;
                    assert (blockedThread2ObjectId[event.getThreadIndex()] == -1L);
                    blockedThread2ObjectId[event.getThreadIndex()] = event.getObjectId();
                    continue;
                }
                if (!(currentPacket instanceof SyncEnteredEvent) || (objectId = blockedThread2ObjectId[(event = (SyncEnteredEvent)currentPacket).getThreadIndex()]) < 0L) continue;
                blockedThread2ObjectId[event.getThreadIndex()] = -1L;
                thread2EnteredKey.put(new SynchronizationEventKey(event.getThreadIndex(), objectId), new EnteredKey((SyncEnteredEvent)event, objectId));
            }
        }
        catch (IOException ex) {
            reader.close();
            throw ex;
        }
        reader.close();
        blockingThreadCache.sort();
        return blockingThreadCache;
    }

    private void add(long objectId, char threadIndex, long lockCount, int stackId, long timestamp, long id) {
        List<Value> list = this.obj2ExitEvents.get(objectId);
        if (list == null) {
            list = new ArrayList<Value>();
            this.obj2ExitEvents.put(objectId, list);
        }
        list.add(new Value(threadIndex, lockCount, stackId, timestamp, id));
    }

    private void sort() {
        this.writeWork = 0L;
        for (List<Value> list : this.obj2ExitEvents.values()) {
            Collections.sort(list);
            assert (this.checkLockCountUniqueness(list));
            this.writeWork += (long)list.size();
        }
        this.writeWork += (long)this.entered2LockCount.size();
    }

    private boolean checkLockCountUniqueness(List<Value> list) {
        for (int i = 1; i < list.size(); ++i) {
            assert (list.get(i).lockCount > list.get(i - 1).lockCount);
        }
        return true;
    }

    @Override
    public Iterator iterator(long objectId, long startBlockedTime, long endBlockedTime, char blockerThread, long lockCountBefore, SyncEnteredEvent exitEvent) {
        long lockCountLimit;
        List<Value> list = this.obj2ExitEvents.get(objectId);
        if (list == null) {
            list = Collections.emptyList();
        }
        int initialIndex = this.findInitialIndex(list, lockCountBefore, blockerThread);
        Long lockCountObj = this.entered2LockCount.get(new EnteredKey(exitEvent, objectId));
        if (lockCountObj != null) {
            lockCountLimit = lockCountObj;
        } else {
            lockCountLimit = list.size();
            long delta = 50000000L;
            long limit = exitEvent.getTimeStamp() + 50000000L;
            for (int i = initialIndex; i < list.size(); ++i) {
                if (list.get(i).timestamp <= limit) continue;
                lockCountLimit = i;
                break;
            }
        }
        return new Iterator(list, lockCountLimit, startBlockedTime, endBlockedTime, initialIndex - 1);
    }

    private int findInitialIndex(List<Value> list, long lockCountBefore, char blockerThread) {
        if (list.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        int index = Collections.binarySearch(list, new Value(lockCountBefore));
        if (index < 0) {
            if ((index = -index - 1) >= list.size()) {
                return index;
            }
            assert (list.get(index).lockCount > lockCountBefore);
        }
        if (blockerThread != '\u0000' && list.get(index).threadIndex != blockerThread && index > 0 && list.get(index - 1).threadIndex == blockerThread) {
            --index;
        }
        return index;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    public boolean isModifiable() {
        return false;
    }

    @Override
    public long calculateWriteWork() {
        return this.writeWork;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt64(this.writeWork);
        reporter.setWork(I18n._s((String)"Writing the blocking threads information .... (<%> %)"), this.writeWork);
        writer.writeInt32(this.obj2ExitEvents.size());
        for (Map.Entry<Long, List<Value>> entry : this.obj2ExitEvents.entrySet()) {
            writer.writeInt64(entry.getKey().longValue());
            List<Value> values = entry.getValue();
            writer.writeInt32(values.size());
            for (Value value : values) {
                reporter.reportNextOrThrow();
                value.write(writer);
            }
        }
        writer.writeInt32(this.entered2LockCount.size());
        for (Map.Entry<Object, Object> entry : this.entered2LockCount.entrySet()) {
            reporter.reportNextOrThrow();
            ((EnteredKey)entry.getKey()).write(writer);
            writer.writeInt64(((Long)entry.getValue()).longValue());
        }
    }

    public final class Iterator
    implements BlockingThreadCacheIterator {
        private final List<Value> list;
        private final long lockCountLimit;
        private final long endBlockedTime;
        private final int initialIndex;
        private int index;
        private long startTimestamp;

        private Iterator(List<Value> list, long lockCountLimit, long startBlockedTime, long endBlockedTime, int initialIndex) {
            this.list = list;
            this.lockCountLimit = lockCountLimit;
            this.endBlockedTime = endBlockedTime;
            this.initialIndex = initialIndex;
            this.index = initialIndex;
            this.startTimestamp = startBlockedTime;
        }

        @Override
        public boolean next() {
            if (this.index >= this.list.size() - 1) {
                this.index = this.list.size();
                return false;
            }
            if (this.index != this.initialIndex) {
                assert (this.index >= 0 && this.index < this.list.size());
                this.startTimestamp = Math.max(this.startTimestamp, this.list.get(this.index).timestamp);
            }
            ++this.index;
            assert (this.list.get(this.index) != null);
            if (this.list.get(this.index).lockCount >= this.lockCountLimit) {
                this.index = this.list.size();
                return false;
            }
            return true;
        }

        @Override
        public char getThread() {
            this.checkValidity();
            return this.list.get(this.index).threadIndex;
        }

        @Override
        public long getBlockedTime() {
            this.checkValidity();
            long end = this.isLastBlockingThread() ? this.endBlockedTime : Math.min(this.endBlockedTime, this.list.get(this.index).timestamp);
            return Math.max(0L, end - this.startTimestamp);
        }

        @Override
        public int getStackTraceIndex() {
            this.checkValidity();
            return this.list.get(this.index).stackId;
        }

        @Override
        public long getId() {
            this.checkValidity();
            return this.list.get(this.index).id;
        }

        private void checkValidity() {
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException("Index " + this.index + " is too big for list (size " + this.list.size() + ").");
            }
        }

        private boolean isLastBlockingThread() {
            this.checkValidity();
            return this.index + 1 == this.list.size() || this.list.get(this.index + 1).lockCount >= this.lockCountLimit;
        }
    }

    private static final class SynchronizationEventKey {
        private final char threadIndex;
        private final long objectId;

        public SynchronizationEventKey(char threadIndex, long objectId) {
            this.threadIndex = threadIndex;
            this.objectId = objectId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.threadIndex;
            result = 31 * result + (int)(this.objectId ^ this.objectId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SynchronizationEventKey other = (SynchronizationEventKey)obj;
            if (this.threadIndex != other.threadIndex) {
                return false;
            }
            return this.objectId == other.objectId;
        }
    }

    private static final class EnteredKey {
        private final char threadIndex;
        private final long timestamp;
        private final long objectId;

        public EnteredKey(SyncEnteredEvent event, long objectId) {
            this(event.getThreadIndex(), event.getTimeStamp(), objectId);
        }

        public EnteredKey(char threadIndex, long timestamp, long objectId) {
            this.threadIndex = threadIndex;
            this.timestamp = timestamp;
            this.objectId = objectId;
        }

        public EnteredKey(ResourceReader reader) throws IOException {
            this.threadIndex = reader.readUint16();
            this.timestamp = reader.readInt64();
            this.objectId = reader.readInt64();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.threadIndex;
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + (int)(this.objectId ^ this.objectId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnteredKey other = (EnteredKey)obj;
            if (this.threadIndex != other.threadIndex) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return this.objectId == other.objectId;
        }

        public void write(ResourceWriter writer) throws IOException {
            writer.writeUint16(this.threadIndex);
            writer.writeInt64(this.timestamp);
            writer.writeInt64(this.objectId);
        }
    }

    private static final class Value
    implements Comparable<Value> {
        private final char threadIndex;
        private final long lockCount;
        private final int stackId;
        private final long timestamp;
        private final long id;

        public Value(long lockCount) {
            this('\u0000', lockCount, 0, 0L, 0L);
        }

        public Value(char threadIndex, long lockCount, int stackId, long timestamp, long id) {
            this.threadIndex = threadIndex;
            this.lockCount = lockCount;
            this.stackId = stackId;
            this.timestamp = timestamp;
            this.id = id;
        }

        public Value(ResourceReader reader) throws IOException {
            this.threadIndex = reader.readUint16();
            this.lockCount = reader.readInt64();
            this.stackId = reader.readInt32();
            this.timestamp = reader.readInt64();
            this.id = reader.readInt64();
        }

        @Override
        public int compareTo(Value o) {
            return this.lockCount == o.lockCount ? 0 : (this.lockCount > o.lockCount ? 1 : -1);
        }

        public void write(ResourceWriter writer) throws IOException {
            writer.writeUint16(this.threadIndex);
            writer.writeInt64(this.lockCount);
            writer.writeInt32(this.stackId);
            writer.writeInt64(this.timestamp);
            writer.writeInt64(this.id);
        }
    }
}

